@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.RestApiPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway REST API Policy.
 * > **Note:** Amazon API Gateway Version 1 resources are used for creating and deploying REST APIs. To create and deploy WebSocket and HTTP APIs, use Amazon API Gateway Version 2 resources.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.apigateway.RestApiPolicy;
 * import com.pulumi.aws.apigateway.RestApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRestApi = new RestApi("testRestApi");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("execute-api:Invoke")
 *                 .resources(testRestApi.executionArn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("123.123.123.123/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRestApiPolicy = new RestApiPolicy("testRestApiPolicy", RestApiPolicyArgs.builder()
 *             .restApiId(testRestApi.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_rest_api_policy` using the REST API ID. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/restApiPolicy:RestApiPolicy example 12345abcde
 * ```
 * @property policy JSON formatted policy document that controls access to the API Gateway.
 * @property restApiId ID of the REST API.
 */
public data class RestApiPolicyArgs(
    public val policy: Output<String>? = null,
    public val restApiId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.RestApiPolicyArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.RestApiPolicyArgs =
        com.pulumi.aws.apigateway.RestApiPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestApiPolicyArgs].
 */
@PulumiTagMarker
public class RestApiPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var restApiId: Output<String>? = null

    /**
     * @param value JSON formatted policy document that controls access to the API Gateway.
     */
    @JvmName("jaeiaobxidjvyxbl")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ID of the REST API.
     */
    @JvmName("prsfvdqsfsasacjw")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value JSON formatted policy document that controls access to the API Gateway.
     */
    @JvmName("vlgrsnupanoghgym")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ID of the REST API.
     */
    @JvmName("ophuakvbttkfvtml")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    internal fun build(): RestApiPolicyArgs = RestApiPolicyArgs(
        policy = policy,
        restApiId = restApiId,
    )
}
