@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.StageArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.StageAccessLogSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.StageAccessLogSettingsArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.StageCanarySettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.StageCanarySettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *  /*
 * Manages an API Gateway Stage. A stage is a named reference to a deployment, which can be done via the `aws.apigateway.Deployment` resource. Stages can be optionally managed further with the `aws.apigateway.BasePathMapping` resource, `aws.apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-stages.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *         var exampleMethodSettings = new MethodSettings("exampleMethodSettings", MethodSettingsArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .stageName(exampleStage.stageName())
 *             .methodPath("*/*")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .metricsEnabled(true)
 *                 .loggingLevel("INFO")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Managing the API Logging CloudWatch Log Group
 * API Gateway provides the ability to [enable CloudWatch API logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html). To manage the CloudWatch Log Group when this feature is enabled, the `aws.cloudwatch.LogGroup` resource can be used where the name matches the API Gateway naming convention. If the CloudWatch Log Group previously exists, import the `aws.cloudwatch.LogGroup` resource into Pulumi as a one time operation. You can recreate the environment without import.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var stageName = config.get("stageName").orElse("example");
 *         var exampleRestApi = new RestApi("exampleRestApi");
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(7)
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .stageName(stageName)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleLogGroup)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_stage` using `REST-API-ID/STAGE-NAME`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/stage:Stage example 12345abcde/example
 * ```
 * @property accessLogSettings Enables access logs for the API stage. See Access Log Settings below.
 * @property cacheClusterEnabled Whether a cache cluster is enabled for the stage
 * @property cacheClusterSize Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
 * @property canarySettings Configuration settings of a canary deployment. See Canary Settings below.
 * @property clientCertificateId Identifier of a client certificate for the stage.
 * @property deployment ID of the deployment that the stage points to
 * @property description Description of the stage.
 * @property documentationVersion Version of the associated API documentation
 * @property restApi ID of the associated REST API
 * @property stageName Name of the stage
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property variables Map that defines the stage variables
 * @property xrayTracingEnabled Whether active tracing with X-ray is enabled. Defaults to `false`.
 */
public data class StageArgs(
    public val accessLogSettings: Output<StageAccessLogSettingsArgs>? = null,
    public val cacheClusterEnabled: Output<Boolean>? = null,
    public val cacheClusterSize: Output<String>? = null,
    public val canarySettings: Output<StageCanarySettingsArgs>? = null,
    public val clientCertificateId: Output<String>? = null,
    public val deployment: Output<String>? = null,
    public val description: Output<String>? = null,
    public val documentationVersion: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val stageName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val variables: Output<Map<String, String>>? = null,
    public val xrayTracingEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.StageArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.StageArgs =
        com.pulumi.aws.apigateway.StageArgs.builder()
            .accessLogSettings(accessLogSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cacheClusterEnabled(cacheClusterEnabled?.applyValue({ args0 -> args0 }))
            .cacheClusterSize(cacheClusterSize?.applyValue({ args0 -> args0 }))
            .canarySettings(canarySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientCertificateId(clientCertificateId?.applyValue({ args0 -> args0 }))
            .deployment(deployment?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .documentationVersion(documentationVersion?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .xrayTracingEnabled(xrayTracingEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageArgs].
 */
@PulumiTagMarker
public class StageArgsBuilder internal constructor() {
    private var accessLogSettings: Output<StageAccessLogSettingsArgs>? = null

    private var cacheClusterEnabled: Output<Boolean>? = null

    private var cacheClusterSize: Output<String>? = null

    private var canarySettings: Output<StageCanarySettingsArgs>? = null

    private var clientCertificateId: Output<String>? = null

    private var deployment: Output<String>? = null

    private var description: Output<String>? = null

    private var documentationVersion: Output<String>? = null

    private var restApi: Output<String>? = null

    private var stageName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var variables: Output<Map<String, String>>? = null

    private var xrayTracingEnabled: Output<Boolean>? = null

    /**
     * @param value Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("rckojdlcqsfmsiyn")
    public suspend fun accessLogSettings(`value`: Output<StageAccessLogSettingsArgs>) {
        this.accessLogSettings = value
    }

    /**
     * @param value Whether a cache cluster is enabled for the stage
     */
    @JvmName("twuwufostuucprrp")
    public suspend fun cacheClusterEnabled(`value`: Output<Boolean>) {
        this.cacheClusterEnabled = value
    }

    /**
     * @param value Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     */
    @JvmName("ylffbxqkelrcdhlg")
    public suspend fun cacheClusterSize(`value`: Output<String>) {
        this.cacheClusterSize = value
    }

    /**
     * @param value Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("qavlgktfihgrwaiy")
    public suspend fun canarySettings(`value`: Output<StageCanarySettingsArgs>) {
        this.canarySettings = value
    }

    /**
     * @param value Identifier of a client certificate for the stage.
     */
    @JvmName("eycuftammsifrspd")
    public suspend fun clientCertificateId(`value`: Output<String>) {
        this.clientCertificateId = value
    }

    /**
     * @param value ID of the deployment that the stage points to
     */
    @JvmName("iiofgfranyfjuioc")
    public suspend fun deployment(`value`: Output<String>) {
        this.deployment = value
    }

    /**
     * @param value Description of the stage.
     */
    @JvmName("isdecxnyahhdilfk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Version of the associated API documentation
     */
    @JvmName("dkcjwblgyurokcff")
    public suspend fun documentationVersion(`value`: Output<String>) {
        this.documentationVersion = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("hiiexvjeeroposbr")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("rhnpgaxecoxwarjx")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kwsrojatjmcghpby")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Map that defines the stage variables
     */
    @JvmName("fgcfggejdsrxpsgu")
    public suspend fun variables(`value`: Output<Map<String, String>>) {
        this.variables = value
    }

    /**
     * @param value Whether active tracing with X-ray is enabled. Defaults to `false`.
     */
    @JvmName("sunybitbpndffwyi")
    public suspend fun xrayTracingEnabled(`value`: Output<Boolean>) {
        this.xrayTracingEnabled = value
    }

    /**
     * @param value Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("dviwwuuypddhlubk")
    public suspend fun accessLogSettings(`value`: StageAccessLogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogSettings = mapped
    }

    /**
     * @param argument Enables access logs for the API stage. See Access Log Settings below.
     */
    @JvmName("mbmiecidbjjmgwfw")
    public suspend
    fun accessLogSettings(argument: suspend StageAccessLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageAccessLogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogSettings = mapped
    }

    /**
     * @param value Whether a cache cluster is enabled for the stage
     */
    @JvmName("iabkrirnsunngoyq")
    public suspend fun cacheClusterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheClusterEnabled = mapped
    }

    /**
     * @param value Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
     */
    @JvmName("poenwlrliyvwgyrw")
    public suspend fun cacheClusterSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheClusterSize = mapped
    }

    /**
     * @param value Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("nrxjivxafqmxxkdq")
    public suspend fun canarySettings(`value`: StageCanarySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canarySettings = mapped
    }

    /**
     * @param argument Configuration settings of a canary deployment. See Canary Settings below.
     */
    @JvmName("tcofmgexvtdunohq")
    public suspend fun canarySettings(argument: suspend StageCanarySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageCanarySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.canarySettings = mapped
    }

    /**
     * @param value Identifier of a client certificate for the stage.
     */
    @JvmName("oomjoopkkrjolrtx")
    public suspend fun clientCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateId = mapped
    }

    /**
     * @param value ID of the deployment that the stage points to
     */
    @JvmName("qjwancmsunrgvngn")
    public suspend fun deployment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployment = mapped
    }

    /**
     * @param value Description of the stage.
     */
    @JvmName("tomxabhihtmkoucm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Version of the associated API documentation
     */
    @JvmName("sylqkfbasyywavgu")
    public suspend fun documentationVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationVersion = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("lwgwmytqioxgmcof")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("tfacrvvbnscpllnt")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ceivjigofctdngfh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rnomdirxxsftvttj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Map that defines the stage variables
     */
    @JvmName("biosfbofncmivwne")
    public suspend fun variables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values Map that defines the stage variables
     */
    @JvmName("efbqoxwmgvnrujeo")
    public fun variables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param value Whether active tracing with X-ray is enabled. Defaults to `false`.
     */
    @JvmName("mootuannbugwxtlt")
    public suspend fun xrayTracingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xrayTracingEnabled = mapped
    }

    internal fun build(): StageArgs = StageArgs(
        accessLogSettings = accessLogSettings,
        cacheClusterEnabled = cacheClusterEnabled,
        cacheClusterSize = cacheClusterSize,
        canarySettings = canarySettings,
        clientCertificateId = clientCertificateId,
        deployment = deployment,
        description = description,
        documentationVersion = documentationVersion,
        restApi = restApi,
        stageName = stageName,
        tags = tags,
        variables = variables,
        xrayTracingEnabled = xrayTracingEnabled,
    )
}
