@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.UsagePlanArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanApiStageArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanApiStageArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanQuotaSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanQuotaSettingsArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanThrottleSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.UsagePlanThrottleSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Usage Plan.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.apigateway.UsagePlan;
 * import com.pulumi.aws.apigateway.UsagePlanArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanQuotaSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var development = new Stage("development", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("development")
 *             .build());
 *         var production = new Stage("production", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("production")
 *             .build());
 *         var exampleUsagePlan = new UsagePlan("exampleUsagePlan", UsagePlanArgs.builder()
 *             .description("my description")
 *             .productCode("MYCODE")
 *             .apiStages(
 *                 UsagePlanApiStageArgs.builder()
 *                     .apiId(exampleRestApi.id())
 *                     .stage(development.stageName())
 *                     .build(),
 *                 UsagePlanApiStageArgs.builder()
 *                     .apiId(exampleRestApi.id())
 *                     .stage(production.stageName())
 *                     .build())
 *             .quotaSettings(UsagePlanQuotaSettingsArgs.builder()
 *                 .limit(20)
 *                 .offset(2)
 *                 .period("WEEK")
 *                 .build())
 *             .throttleSettings(UsagePlanThrottleSettingsArgs.builder()
 *                 .burstLimit(5)
 *                 .rateLimit(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/usagePlan:UsagePlan myusageplan <usage_plan_id>
 * ```
 * @property apiStages Associated API stages of the usage plan.
 * @property description Description of a usage plan.
 * @property name Name of the usage plan.
 * @property productCode AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
 * @property quotaSettings The quota settings of the usage plan.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throttleSettings The throttling limits of the usage plan.
 */
public data class UsagePlanArgs(
    public val apiStages: Output<List<UsagePlanApiStageArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val quotaSettings: Output<UsagePlanQuotaSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throttleSettings: Output<UsagePlanThrottleSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.UsagePlanArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.UsagePlanArgs =
        com.pulumi.aws.apigateway.UsagePlanArgs.builder()
            .apiStages(
                apiStages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaSettings(quotaSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throttleSettings(
                throttleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UsagePlanArgs].
 */
@PulumiTagMarker
public class UsagePlanArgsBuilder internal constructor() {
    private var apiStages: Output<List<UsagePlanApiStageArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var productCode: Output<String>? = null

    private var quotaSettings: Output<UsagePlanQuotaSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throttleSettings: Output<UsagePlanThrottleSettingsArgs>? = null

    /**
     * @param value Associated API stages of the usage plan.
     */
    @JvmName("woliucwadddxusig")
    public suspend fun apiStages(`value`: Output<List<UsagePlanApiStageArgs>>) {
        this.apiStages = value
    }

    @JvmName("obwjkmreghvdttgy")
    public suspend fun apiStages(vararg values: Output<UsagePlanApiStageArgs>) {
        this.apiStages = Output.all(values.asList())
    }

    /**
     * @param values Associated API stages of the usage plan.
     */
    @JvmName("dwduxjaxlntqacpq")
    public suspend fun apiStages(values: List<Output<UsagePlanApiStageArgs>>) {
        this.apiStages = Output.all(values)
    }

    /**
     * @param value Description of a usage plan.
     */
    @JvmName("pvbmraochoiwqwrx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the usage plan.
     */
    @JvmName("cnbvwgpdqknlqttl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    @JvmName("udalmufnfuewwcrv")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The quota settings of the usage plan.
     */
    @JvmName("xwumueihiotbejxj")
    public suspend fun quotaSettings(`value`: Output<UsagePlanQuotaSettingsArgs>) {
        this.quotaSettings = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kehqiawuxcvwwhhf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The throttling limits of the usage plan.
     */
    @JvmName("sirvqtxikprgxtru")
    public suspend fun throttleSettings(`value`: Output<UsagePlanThrottleSettingsArgs>) {
        this.throttleSettings = value
    }

    /**
     * @param value Associated API stages of the usage plan.
     */
    @JvmName("iiaulyupkikfouog")
    public suspend fun apiStages(`value`: List<UsagePlanApiStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("umhblltbgmqdnhaw")
    public suspend fun apiStages(argument: List<suspend UsagePlanApiStageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("ylkljbqeigctalih")
    public suspend fun apiStages(vararg argument: suspend UsagePlanApiStageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UsagePlanApiStageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param argument Associated API stages of the usage plan.
     */
    @JvmName("iayaxluiojvqtlop")
    public suspend fun apiStages(argument: suspend UsagePlanApiStageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UsagePlanApiStageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.apiStages = mapped
    }

    /**
     * @param values Associated API stages of the usage plan.
     */
    @JvmName("ayhhmirkuqsxropo")
    public suspend fun apiStages(vararg values: UsagePlanApiStageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiStages = mapped
    }

    /**
     * @param value Description of a usage plan.
     */
    @JvmName("crdbysedcxvsekmi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the usage plan.
     */
    @JvmName("bgxyenddylwcsufw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value AWS Marketplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    @JvmName("mibgublowvcdhdws")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The quota settings of the usage plan.
     */
    @JvmName("dtdljmskottmiqxn")
    public suspend fun quotaSettings(`value`: UsagePlanQuotaSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaSettings = mapped
    }

    /**
     * @param argument The quota settings of the usage plan.
     */
    @JvmName("lcgydxuittyrnlgl")
    public suspend fun quotaSettings(argument: suspend UsagePlanQuotaSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UsagePlanQuotaSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quotaSettings = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tcyleygjiksfccsy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kqmtryjsbnsasnew")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The throttling limits of the usage plan.
     */
    @JvmName("xnhvacxeuyokyxei")
    public suspend fun throttleSettings(`value`: UsagePlanThrottleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleSettings = mapped
    }

    /**
     * @param argument The throttling limits of the usage plan.
     */
    @JvmName("yryyplddrohpdstf")
    public suspend
    fun throttleSettings(argument: suspend UsagePlanThrottleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UsagePlanThrottleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.throttleSettings = mapped
    }

    internal fun build(): UsagePlanArgs = UsagePlanArgs(
        apiStages = apiStages,
        description = description,
        name = name,
        productCode = productCode,
        quotaSettings = quotaSettings,
        tags = tags,
        throttleSettings = throttleSettings,
    )
}
