@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UsagePlanKey].
 */
@PulumiTagMarker
public class UsagePlanKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsagePlanKeyArgs = UsagePlanKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsagePlanKeyArgsBuilder.() -> Unit) {
        val builder = UsagePlanKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UsagePlanKey {
        val builtJavaResource = com.pulumi.aws.apigateway.UsagePlanKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsagePlanKey(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Usage Plan Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.UsagePlan;
 * import com.pulumi.aws.apigateway.UsagePlanArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs;
 * import com.pulumi.aws.apigateway.ApiKey;
 * import com.pulumi.aws.apigateway.UsagePlanKey;
 * import com.pulumi.aws.apigateway.UsagePlanKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RestApi("test");
 *         var myusageplan = new UsagePlan("myusageplan", UsagePlanArgs.builder()
 *             .apiStages(UsagePlanApiStageArgs.builder()
 *                 .apiId(test.id())
 *                 .stage(aws_api_gateway_stage.foo().stage_name())
 *                 .build())
 *             .build());
 *         var mykey = new ApiKey("mykey");
 *         var main = new UsagePlanKey("main", UsagePlanKeyArgs.builder()
 *             .keyId(mykey.id())
 *             .keyType("API_KEY")
 *             .usagePlanId(myusageplan.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan Key using the `USAGE-PLAN-ID/USAGE-PLAN-KEY-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/usagePlanKey:UsagePlanKey key 12345abcde/zzz
 * ```
 *
 */
public class UsagePlanKey internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.UsagePlanKey,
) : KotlinCustomResource(javaResource, UsagePlanKeyMapper) {
    /**
     * Identifier of the API key resource.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * Type of the API key resource. Currently, the valid key type is API_KEY.
     */
    public val keyType: Output<String>
        get() = javaResource.keyType().applyValue({ args0 -> args0 })

    /**
     * Name of a usage plan key.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Id of the usage plan resource representing to associate the key to.
     */
    public val usagePlanId: Output<String>
        get() = javaResource.usagePlanId().applyValue({ args0 -> args0 })

    /**
     * Value of a usage plan key.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object UsagePlanKeyMapper : ResourceMapper<UsagePlanKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.UsagePlanKey::class == javaResource::class

    override fun map(javaResource: Resource): UsagePlanKey = UsagePlanKey(
        javaResource as
            com.pulumi.aws.apigateway.UsagePlanKey,
    )
}

/**
 * @see [UsagePlanKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsagePlanKey].
 */
public suspend fun usagePlanKey(
    name: String,
    block: suspend UsagePlanKeyResourceBuilder.() -> Unit,
): UsagePlanKey {
    val builder = UsagePlanKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsagePlanKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usagePlanKey(name: String): UsagePlanKey {
    val builder = UsagePlanKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
