@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.UsagePlanKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Usage Plan Key.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.UsagePlan;
 * import com.pulumi.aws.apigateway.UsagePlanArgs;
 * import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageArgs;
 * import com.pulumi.aws.apigateway.ApiKey;
 * import com.pulumi.aws.apigateway.UsagePlanKey;
 * import com.pulumi.aws.apigateway.UsagePlanKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RestApi("test");
 *         var myusageplan = new UsagePlan("myusageplan", UsagePlanArgs.builder()
 *             .apiStages(UsagePlanApiStageArgs.builder()
 *                 .apiId(test.id())
 *                 .stage(aws_api_gateway_stage.foo().stage_name())
 *                 .build())
 *             .build());
 *         var mykey = new ApiKey("mykey");
 *         var main = new UsagePlanKey("main", UsagePlanKeyArgs.builder()
 *             .keyId(mykey.id())
 *             .keyType("API_KEY")
 *             .usagePlanId(myusageplan.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Usage Plan Key using the `USAGE-PLAN-ID/USAGE-PLAN-KEY-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/usagePlanKey:UsagePlanKey key 12345abcde/zzz
 * ```
 * @property keyId Identifier of the API key resource.
 * @property keyType Type of the API key resource. Currently, the valid key type is API_KEY.
 * @property usagePlanId Id of the usage plan resource representing to associate the key to.
 */
public data class UsagePlanKeyArgs(
    public val keyId: Output<String>? = null,
    public val keyType: Output<String>? = null,
    public val usagePlanId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.UsagePlanKeyArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.UsagePlanKeyArgs =
        com.pulumi.aws.apigateway.UsagePlanKeyArgs.builder()
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .keyType(keyType?.applyValue({ args0 -> args0 }))
            .usagePlanId(usagePlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsagePlanKeyArgs].
 */
@PulumiTagMarker
public class UsagePlanKeyArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var keyType: Output<String>? = null

    private var usagePlanId: Output<String>? = null

    /**
     * @param value Identifier of the API key resource.
     */
    @JvmName("ryvorebhccjnwlej")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Type of the API key resource. Currently, the valid key type is API_KEY.
     */
    @JvmName("suaydfviqibeircl")
    public suspend fun keyType(`value`: Output<String>) {
        this.keyType = value
    }

    /**
     * @param value Id of the usage plan resource representing to associate the key to.
     */
    @JvmName("geqxhtusxlelaupg")
    public suspend fun usagePlanId(`value`: Output<String>) {
        this.usagePlanId = value
    }

    /**
     * @param value Identifier of the API key resource.
     */
    @JvmName("dckpcqosteodeudw")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Type of the API key resource. Currently, the valid key type is API_KEY.
     */
    @JvmName("uvkhgrbxfspgevxj")
    public suspend fun keyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyType = mapped
    }

    /**
     * @param value Id of the usage plan resource representing to associate the key to.
     */
    @JvmName("oomopkhcyehcvyju")
    public suspend fun usagePlanId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usagePlanId = mapped
    }

    internal fun build(): UsagePlanKeyArgs = UsagePlanKeyArgs(
        keyId = keyId,
        keyType = keyType,
        usagePlanId = usagePlanId,
    )
}
