@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.VpcLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway VPC Link.
 * > **Note:** Amazon API Gateway Version 1 VPC Links enable private integrations that connect REST APIs to private resources in a VPC.
 * To enable private integration for HTTP APIs, use the Amazon API Gateway Version 2 VPC Link resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import com.pulumi.aws.apigateway.VpcLink;
 * import com.pulumi.aws.apigateway.VpcLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLoadBalancer = new LoadBalancer("exampleLoadBalancer", LoadBalancerArgs.builder()
 *             .internal(true)
 *             .loadBalancerType("network")
 *             .subnetMappings(LoadBalancerSubnetMappingArgs.builder()
 *                 .subnetId("12345")
 *                 .build())
 *             .build());
 *         var exampleVpcLink = new VpcLink("exampleVpcLink", VpcLinkArgs.builder()
 *             .description("example description")
 *             .targetArn(exampleLoadBalancer.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway VPC Link using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/vpcLink:VpcLink example 12345abcde
 * ```
 * @property description Description of the VPC link.
 * @property name Name used to label and identify the VPC link.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetArn List of network load balancer arns in the VPC targeted by the VPC link. Currently AWS only supports 1 target.
 */
public data class VpcLinkArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.VpcLinkArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.VpcLinkArgs =
        com.pulumi.aws.apigateway.VpcLinkArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetArn(targetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcLinkArgs].
 */
@PulumiTagMarker
public class VpcLinkArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetArn: Output<String>? = null

    /**
     * @param value Description of the VPC link.
     */
    @JvmName("rtfuqjmravbtbplu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name used to label and identify the VPC link.
     */
    @JvmName("aqobugoihhvfjruq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gbuqcokwcyognoyc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of network load balancer arns in the VPC targeted by the VPC link. Currently AWS only supports 1 target.
     */
    @JvmName("irjbwdkopjfxffdg")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value Description of the VPC link.
     */
    @JvmName("ittkhsuhqqabtioq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name used to label and identify the VPC link.
     */
    @JvmName("otljeptdnilxkiby")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jfcnxyxjymiuaqok")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lmgfowjuurstelgv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of network load balancer arns in the VPC targeted by the VPC link. Currently AWS only supports 1 target.
     */
    @JvmName("fmrgwiwfgjfrqddu")
    public suspend fun targetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    internal fun build(): VpcLinkArgs = VpcLinkArgs(
        description = description,
        name = name,
        tags = tags,
        targetArn = targetArn,
    )
}
