@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property method HTTP verb of a method. The default value is `*` for any method.
 * @property name Name of the targeted API entity.
 * @property path URL path of the target. The default value is `/` for the root resource.
 * @property statusCode HTTP status code of a response. The default value is `*` for any status code.
 * @property type Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
 */
public data class DocumentationPartLocationArgs(
    public val method: Output<String>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
    public val statusCode: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs =
        com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs.builder()
            .method(method?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentationPartLocationArgs].
 */
@PulumiTagMarker
public class DocumentationPartLocationArgsBuilder internal constructor() {
    private var method: Output<String>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var statusCode: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value HTTP verb of a method. The default value is `*` for any method.
     */
    @JvmName("tmaywrggtufkievd")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Name of the targeted API entity.
     */
    @JvmName("dpaimakeebewvqlx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URL path of the target. The default value is `/` for the root resource.
     */
    @JvmName("mrdnctrnfsqtcgfy")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value HTTP status code of a response. The default value is `*` for any status code.
     */
    @JvmName("waqrxseabpyqwpkc")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
     */
    @JvmName("tlpanjcokedqdghj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value HTTP verb of a method. The default value is `*` for any method.
     */
    @JvmName("oyyvtnqhcnmxqexu")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Name of the targeted API entity.
     */
    @JvmName("bluewmlwwvmhdvqb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URL path of the target. The default value is `/` for the root resource.
     */
    @JvmName("kdqxbttwxbdirpde")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value HTTP status code of a response. The default value is `*` for any status code.
     */
    @JvmName("eihebtykpxminwtp")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    /**
     * @param value Type of API entity to which the documentation content appliesE.g., `API`, `METHOD` or `REQUEST_BODY`
     */
    @JvmName("ojoqxhhxamwuwsbu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DocumentationPartLocationArgs = DocumentationPartLocationArgs(
        method = method,
        name = name,
        path = path,
        statusCode = statusCode,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
