@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property types List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
 */
public data class DomainNameEndpointConfigurationArgs(
    public val types: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs =
        com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs.builder()
            .types(types.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class DomainNameEndpointConfigurationArgsBuilder internal constructor() {
    private var types: Output<String>? = null

    /**
     * @param value List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     */
    @JvmName("uojhyimkgivckhwc")
    public suspend fun types(`value`: Output<String>) {
        this.types = value
    }

    /**
     * @param value List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE` or `REGIONAL`. If unspecified, defaults to `EDGE`. Must be declared as `REGIONAL` in non-Commercial partitions. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     */
    @JvmName("llbisumrjdfgtnjd")
    public suspend fun types(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    internal fun build(): DomainNameEndpointConfigurationArgs = DomainNameEndpointConfigurationArgs(
        types = types ?: throw PulumiNullFieldException("types"),
    )
}
