@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetAuthorizersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuthorizers.
 * @property restApiId ID of the associated REST API.
 */
public data class GetAuthorizersPlainArgs(
    public val restApiId: String,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetAuthorizersPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetAuthorizersPlainArgs =
        com.pulumi.aws.apigateway.inputs.GetAuthorizersPlainArgs.builder()
            .restApiId(restApiId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizersPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizersPlainArgsBuilder internal constructor() {
    private var restApiId: String? = null

    /**
     * @param value ID of the associated REST API.
     */
    @JvmName("gwswdavdrgtgujrh")
    public suspend fun restApiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restApiId = mapped
    }

    internal fun build(): GetAuthorizersPlainArgs = GetAuthorizersPlainArgs(
        restApiId = restApiId ?: throw PulumiNullFieldException("restApiId"),
    )
}
