@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetDomainNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomainName.
 * @property domainName Fully-qualified domain name to look up. If no domain name is found, an error will be returned.
 * @property tags Key-value map of tags for the resource.
 */
public data class GetDomainNamePlainArgs(
    public val domainName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetDomainNamePlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetDomainNamePlainArgs =
        com.pulumi.aws.apigateway.inputs.GetDomainNamePlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDomainNamePlainArgs].
 */
@PulumiTagMarker
public class GetDomainNamePlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Fully-qualified domain name to look up. If no domain name is found, an error will be returned.
     */
    @JvmName("erlwttkfhpnsvdrg")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Key-value map of tags for the resource.
     */
    @JvmName("trdcqycjhdodenga")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the resource.
     */
    @JvmName("obianberlvynaivp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDomainNamePlainArgs = GetDomainNamePlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        tags = tags,
    )
}
