@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.GetExportPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getExport.
 * @property accepts Content-type of the export. Valid values are `application/json` and `application/yaml` are supported for `export_type` `ofoas30` and `swagger`.
 * @property exportType Type of export. Acceptable values are `oas30` for OpenAPI 3.0.x and `swagger` for Swagger/OpenAPI 2.0.
 * @property parameters Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
 * @property restApiId Identifier of the associated REST API.
 * @property stageName Name of the Stage that will be exported.
 */
public data class GetExportPlainArgs(
    public val accepts: String? = null,
    public val exportType: String,
    public val parameters: Map<String, String>? = null,
    public val restApiId: String,
    public val stageName: String,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.GetExportPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.GetExportPlainArgs =
        com.pulumi.aws.apigateway.inputs.GetExportPlainArgs.builder()
            .accepts(accepts?.let({ args0 -> args0 }))
            .exportType(exportType.let({ args0 -> args0 }))
            .parameters(parameters?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .restApiId(restApiId.let({ args0 -> args0 }))
            .stageName(stageName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExportPlainArgs].
 */
@PulumiTagMarker
public class GetExportPlainArgsBuilder internal constructor() {
    private var accepts: String? = null

    private var exportType: String? = null

    private var parameters: Map<String, String>? = null

    private var restApiId: String? = null

    private var stageName: String? = null

    /**
     * @param value Content-type of the export. Valid values are `application/json` and `application/yaml` are supported for `export_type` `ofoas30` and `swagger`.
     */
    @JvmName("sgwrixrmxdldwyrf")
    public suspend fun accepts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accepts = mapped
    }

    /**
     * @param value Type of export. Acceptable values are `oas30` for OpenAPI 3.0.x and `swagger` for Swagger/OpenAPI 2.0.
     */
    @JvmName("omptglokjpawheyb")
    public suspend fun exportType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.exportType = mapped
    }

    /**
     * @param value Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
     */
    @JvmName("dosyaqounkwstcsj")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameters = mapped
    }

    /**
     * @param values Key-value map of query string parameters that specify properties of the export. the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions.
     */
    @JvmName("rcbncukqjbnjpwiq")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parameters = mapped
    }

    /**
     * @param value Identifier of the associated REST API.
     */
    @JvmName("yewmqnvkaqojrfmm")
    public suspend fun restApiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restApiId = mapped
    }

    /**
     * @param value Name of the Stage that will be exported.
     */
    @JvmName("ybkjnhqalsscpbnl")
    public suspend fun stageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stageName = mapped
    }

    internal fun build(): GetExportPlainArgs = GetExportPlainArgs(
        accepts = accepts,
        exportType = exportType ?: throw PulumiNullFieldException("exportType"),
        parameters = parameters,
        restApiId = restApiId ?: throw PulumiNullFieldException("restApiId"),
        stageName = stageName ?: throw PulumiNullFieldException("stageName"),
    )
}
