@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.RestApiEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property types List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
 * @property vpcEndpointIds Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
 */
public data class RestApiEndpointConfigurationArgs(
    public val types: Output<String>,
    public val vpcEndpointIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.RestApiEndpointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.RestApiEndpointConfigurationArgs =
        com.pulumi.aws.apigateway.inputs.RestApiEndpointConfigurationArgs.builder()
            .types(types.applyValue({ args0 -> args0 }))
            .vpcEndpointIds(vpcEndpointIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RestApiEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class RestApiEndpointConfigurationArgsBuilder internal constructor() {
    private var types: Output<String>? = null

    private var vpcEndpointIds: Output<List<String>>? = null

    /**
     * @param value List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     */
    @JvmName("ynhortiuhbrfngkj")
    public suspend fun types(`value`: Output<String>) {
        this.types = value
    }

    /**
     * @param value Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     */
    @JvmName("jnrxcnkspxjkljfr")
    public suspend fun vpcEndpointIds(`value`: Output<List<String>>) {
        this.vpcEndpointIds = value
    }

    @JvmName("wptovqpcvlphmpyx")
    public suspend fun vpcEndpointIds(vararg values: Output<String>) {
        this.vpcEndpointIds = Output.all(values.asList())
    }

    /**
     * @param values Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     */
    @JvmName("uptypmdcxuppqmlm")
    public suspend fun vpcEndpointIds(values: List<Output<String>>) {
        this.vpcEndpointIds = Output.all(values)
    }

    /**
     * @param value List of endpoint types. This resource currently only supports managing a single value. Valid values: `EDGE`, `REGIONAL` or `PRIVATE`. If unspecified, defaults to `EDGE`. If set to `PRIVATE` recommend to set `put_rest_api_mode` = `merge` to not cause the endpoints and associated Route53 records to be deleted. Refer to the [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/create-regional-api.html) for more information on the difference between edge-optimized and regional APIs.
     */
    @JvmName("svwrapkarsgdjncm")
    public suspend fun types(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.types = mapped
    }

    /**
     * @param value Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     */
    @JvmName("ydyyjdhtqsmwpsml")
    public suspend fun vpcEndpointIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointIds = mapped
    }

    /**
     * @param values Set of VPC Endpoint identifiers. It is only supported for `PRIVATE` endpoint type. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `vpcEndpointIds` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is provided and is different than the OpenAPI value, **the argument value will override the OpenAPI value**.
     */
    @JvmName("temuedfkphgovlot")
    public suspend fun vpcEndpointIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcEndpointIds = mapped
    }

    internal fun build(): RestApiEndpointConfigurationArgs = RestApiEndpointConfigurationArgs(
        types = types ?: throw PulumiNullFieldException("types"),
        vpcEndpointIds = vpcEndpointIds,
    )
}
