@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.StageAccessLogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationArn ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
 * @property format Formatting and values recorded in the logs.
 * For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
 */
public data class StageAccessLogSettingsArgs(
    public val destinationArn: Output<String>,
    public val format: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.StageAccessLogSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.StageAccessLogSettingsArgs =
        com.pulumi.aws.apigateway.inputs.StageAccessLogSettingsArgs.builder()
            .destinationArn(destinationArn.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageAccessLogSettingsArgs].
 */
@PulumiTagMarker
public class StageAccessLogSettingsArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var format: Output<String>? = null

    /**
     * @param value ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
     */
    @JvmName("trssqfcmcjhqhgpq")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value Formatting and values recorded in the logs.
     * For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
     */
    @JvmName("hmmgwmfqwkyloffg")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value ARN of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with `amazon-apigateway-`. Automatically removes trailing `:*` if present.
     */
    @JvmName("ccppxkihgieiwdwe")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value Formatting and values recorded in the logs.
     * For more information on configuring the log format rules visit the AWS [documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html)
     */
    @JvmName("jptligyjjtalshvj")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    internal fun build(): StageAccessLogSettingsArgs = StageAccessLogSettingsArgs(
        destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        format = format ?: throw PulumiNullFieldException("format"),
    )
}
