@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.UsagePlanApiStageThrottleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property burstLimit The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
 * @property path Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
 * @property rateLimit The API request steady-state rate limit.
 */
public data class UsagePlanApiStageThrottleArgs(
    public val burstLimit: Output<Int>? = null,
    public val path: Output<String>,
    public val rateLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.UsagePlanApiStageThrottleArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.UsagePlanApiStageThrottleArgs =
        com.pulumi.aws.apigateway.inputs.UsagePlanApiStageThrottleArgs.builder()
            .burstLimit(burstLimit?.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .rateLimit(rateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsagePlanApiStageThrottleArgs].
 */
@PulumiTagMarker
public class UsagePlanApiStageThrottleArgsBuilder internal constructor() {
    private var burstLimit: Output<Int>? = null

    private var path: Output<String>? = null

    private var rateLimit: Output<Double>? = null

    /**
     * @param value The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
     */
    @JvmName("ptppgptwvntwvvgd")
    public suspend fun burstLimit(`value`: Output<Int>) {
        this.burstLimit = value
    }

    /**
     * @param value Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
     */
    @JvmName("axikyahucihsmgyf")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The API request steady-state rate limit.
     */
    @JvmName("arwtpukxlindpfbj")
    public suspend fun rateLimit(`value`: Output<Double>) {
        this.rateLimit = value
    }

    /**
     * @param value The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
     */
    @JvmName("hljkasjnhxqxflow")
    public suspend fun burstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstLimit = mapped
    }

    /**
     * @param value Method to apply the throttle settings for. Specfiy the path and method, for example `/test/GET`.
     */
    @JvmName("pbjdehgfvioxoxja")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The API request steady-state rate limit.
     */
    @JvmName("gewyqrjqvwlegppq")
    public suspend fun rateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimit = mapped
    }

    internal fun build(): UsagePlanApiStageThrottleArgs = UsagePlanApiStageThrottleArgs(
        burstLimit = burstLimit,
        path = path ?: throw PulumiNullFieldException("path"),
        rateLimit = rateLimit,
    )
}
