@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.UsagePlanQuotaSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property limit Maximum number of requests that can be made in a given time period.
 * @property offset Number of requests subtracted from the given limit in the initial time period.
 * @property period Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
 */
public data class UsagePlanQuotaSettingsArgs(
    public val limit: Output<Int>,
    public val offset: Output<Int>? = null,
    public val period: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.UsagePlanQuotaSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.UsagePlanQuotaSettingsArgs =
        com.pulumi.aws.apigateway.inputs.UsagePlanQuotaSettingsArgs.builder()
            .limit(limit.applyValue({ args0 -> args0 }))
            .offset(offset?.applyValue({ args0 -> args0 }))
            .period(period.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsagePlanQuotaSettingsArgs].
 */
@PulumiTagMarker
public class UsagePlanQuotaSettingsArgsBuilder internal constructor() {
    private var limit: Output<Int>? = null

    private var offset: Output<Int>? = null

    private var period: Output<String>? = null

    /**
     * @param value Maximum number of requests that can be made in a given time period.
     */
    @JvmName("rgdsnhncpaxnqofm")
    public suspend fun limit(`value`: Output<Int>) {
        this.limit = value
    }

    /**
     * @param value Number of requests subtracted from the given limit in the initial time period.
     */
    @JvmName("ackaivmikvomhcqi")
    public suspend fun offset(`value`: Output<Int>) {
        this.offset = value
    }

    /**
     * @param value Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     */
    @JvmName("wsnmycplujjgaucg")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value Maximum number of requests that can be made in a given time period.
     */
    @JvmName("lptuagsyeyncxanj")
    public suspend fun limit(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    /**
     * @param value Number of requests subtracted from the given limit in the initial time period.
     */
    @JvmName("bnqdiikieoowdytk")
    public suspend fun offset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offset = mapped
    }

    /**
     * @param value Time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     */
    @JvmName("dngbhduxnqcdgbyg")
    public suspend fun period(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.period = mapped
    }

    internal fun build(): UsagePlanQuotaSettingsArgs = UsagePlanQuotaSettingsArgs(
        limit = limit ?: throw PulumiNullFieldException("limit"),
        offset = offset,
        period = period ?: throw PulumiNullFieldException("period"),
    )
}
