@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.inputs

import com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property burstLimit The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
 * @property rateLimit The API request steady-state rate limit.
 */
public data class UsagePlanThrottleSettingsArgs(
    public val burstLimit: Output<Int>? = null,
    public val rateLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs =
        com.pulumi.aws.apigateway.inputs.UsagePlanThrottleSettingsArgs.builder()
            .burstLimit(burstLimit?.applyValue({ args0 -> args0 }))
            .rateLimit(rateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsagePlanThrottleSettingsArgs].
 */
@PulumiTagMarker
public class UsagePlanThrottleSettingsArgsBuilder internal constructor() {
    private var burstLimit: Output<Int>? = null

    private var rateLimit: Output<Double>? = null

    /**
     * @param value The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
     */
    @JvmName("wtntsgfebgrnuepp")
    public suspend fun burstLimit(`value`: Output<Int>) {
        this.burstLimit = value
    }

    /**
     * @param value The API request steady-state rate limit.
     */
    @JvmName("bqaqumjopioujmph")
    public suspend fun rateLimit(`value`: Output<Double>) {
        this.rateLimit = value
    }

    /**
     * @param value The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.
     */
    @JvmName("edwmdvojuqclmxdp")
    public suspend fun burstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstLimit = mapped
    }

    /**
     * @param value The API request steady-state rate limit.
     */
    @JvmName("fchaddikegknayiw")
    public suspend fun rateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimit = mapped
    }

    internal fun build(): UsagePlanThrottleSettingsArgs = UsagePlanThrottleSettingsArgs(
        burstLimit = burstLimit,
        rateLimit = rateLimit,
    )
}
