@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property burstLimit Absolute maximum number of times API Gateway allows the API to be called per second (RPS).
 * @property rateLimit Number of times API Gateway allows the API to be called per second on average (RPS).
 */
public data class AccountThrottleSetting(
    public val burstLimit: Int? = null,
    public val rateLimit: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.AccountThrottleSetting):
            AccountThrottleSetting = AccountThrottleSetting(
            burstLimit = javaType.burstLimit().map({ args0 -> args0 }).orElse(null),
            rateLimit = javaType.rateLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
