@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAuthorizer.
 * @property arn ARN of the API Gateway Authorizer.
 * @property authorizerCredentials Credentials required for the authorizer.
 * @property authorizerId
 * @property authorizerResultTtlInSeconds TTL of cached authorizer results in seconds.
 * @property authorizerUri Authorizer's Uniform Resource Identifier (URI).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identitySource Source of the identity in an incoming request.
 * @property identityValidationExpression Validation expression for the incoming identity.
 * @property name Name of the authorizer.
 * @property providerArns List of the Amazon Cognito user pool ARNs.
 * @property restApiId
 * @property type Type of the authorizer.
 */
public data class GetAuthorizerResult(
    public val arn: String,
    public val authorizerCredentials: String,
    public val authorizerId: String,
    public val authorizerResultTtlInSeconds: Int,
    public val authorizerUri: String,
    public val id: String,
    public val identitySource: String,
    public val identityValidationExpression: String,
    public val name: String,
    public val providerArns: List<String>,
    public val restApiId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetAuthorizerResult):
            GetAuthorizerResult = GetAuthorizerResult(
            arn = javaType.arn(),
            authorizerCredentials = javaType.authorizerCredentials(),
            authorizerId = javaType.authorizerId(),
            authorizerResultTtlInSeconds = javaType.authorizerResultTtlInSeconds(),
            authorizerUri = javaType.authorizerUri(),
            id = javaType.id(),
            identitySource = javaType.identitySource(),
            identityValidationExpression = javaType.identityValidationExpression(),
            name = javaType.name(),
            providerArns = javaType.providerArns().map({ args0 -> args0 }),
            restApiId = javaType.restApiId(),
            type = javaType.type(),
        )
    }
}
