@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRestApi.
 * @property apiKeySource Source of the API key for requests.
 * @property arn ARN of the REST API.
 * @property binaryMediaTypes List of binary media types supported by the REST API.
 * @property description Description of the REST API.
 * @property endpointConfigurations The endpoint configuration of this RestApi showing the endpoint types of the API.
 * @property executionArn Execution ARN part to be used in `lambda_permission`'s `source_arn` when allowing API Gateway to invoke a Lambda function, e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j`, which can be concatenated with allowed stage, method and resource path.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property minimumCompressionSize Minimum response size to compress for the REST API.
 * @property name
 * @property policy JSON formatted policy document that controls access to the API Gateway.
 * @property rootResourceId Set to the ID of the API Gateway Resource on the found REST API where the route matches '/'.
 * @property tags Key-value map of resource tags.
 */
public data class GetRestApiResult(
    public val apiKeySource: String,
    public val arn: String,
    public val binaryMediaTypes: List<String>,
    public val description: String,
    public val endpointConfigurations: List<GetRestApiEndpointConfiguration>,
    public val executionArn: String,
    public val id: String,
    public val minimumCompressionSize: String,
    public val name: String,
    public val policy: String,
    public val rootResourceId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetRestApiResult):
            GetRestApiResult = GetRestApiResult(
            apiKeySource = javaType.apiKeySource(),
            arn = javaType.arn(),
            binaryMediaTypes = javaType.binaryMediaTypes().map({ args0 -> args0 }),
            description = javaType.description(),
            endpointConfigurations = javaType.endpointConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apigateway.kotlin.outputs.GetRestApiEndpointConfiguration.Companion.toKotlin(args0)
                })
            }),
            executionArn = javaType.executionArn(),
            id = javaType.id(),
            minimumCompressionSize = javaType.minimumCompressionSize(),
            name = javaType.name(),
            policy = javaType.policy(),
            rootResourceId = javaType.rootResourceId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
