@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcLink.
 * @property description Description of the VPC link.
 * @property id Set to the ID of the found API Gateway VPC Link.
 * @property name
 * @property status Status of the VPC link.
 * @property statusMessage Status message of the VPC link.
 * @property tags Key-value map of resource tags
 * @property targetArns List of network load balancer arns in the VPC targeted by the VPC link. Currently AWS only supports 1 target.
 */
public data class GetVpcLinkResult(
    public val description: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val statusMessage: String,
    public val tags: Map<String, String>,
    public val targetArns: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.GetVpcLinkResult):
            GetVpcLinkResult = GetVpcLinkResult(
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetArns = javaType.targetArns().map({ args0 -> args0 }),
        )
    }
}
