@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property percentTraffic Percent `0.0` - `100.0` of traffic to divert to the canary deployment.
 * @property stageVariableOverrides Map of overridden stage `variables` (including new variables) for the canary deployment.
 * @property useStageCache Whether the canary deployment uses the stage cache. Defaults to false.
 */
public data class StageCanarySettings(
    public val percentTraffic: Double? = null,
    public val stageVariableOverrides: Map<String, String>? = null,
    public val useStageCache: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.StageCanarySettings):
            StageCanarySettings = StageCanarySettings(
            percentTraffic = javaType.percentTraffic().map({ args0 -> args0 }).orElse(null),
            stageVariableOverrides = javaType.stageVariableOverrides().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            useStageCache = javaType.useStageCache().map({ args0 -> args0 }).orElse(null),
        )
    }
}
