@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property apiId API Id of the associated API stage in a usage plan.
 * @property stage API stage name of the associated API stage in a usage plan.
 * @property throttles The throttling limits of the usage plan.
 */
public data class UsagePlanApiStage(
    public val apiId: String,
    public val stage: String,
    public val throttles: List<UsagePlanApiStageThrottle>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigateway.outputs.UsagePlanApiStage):
            UsagePlanApiStage = UsagePlanApiStage(
            apiId = javaType.apiId(),
            stage = javaType.stage(),
            throttles = javaType.throttles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apigateway.kotlin.outputs.UsagePlanApiStageThrottle.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
