@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.ApiMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 API mapping.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.ApiMapping;
 * import com.pulumi.aws.apigatewayv2.ApiMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApiMapping("example", ApiMappingArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .domainName(aws_apigatewayv2_domain_name.example().id())
 *             .stage(aws_apigatewayv2_stage.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_api_mapping` using the API mapping identifier and domain name. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/apiMapping:ApiMapping example 1122334/ws-api.example.com
 * ```
 * @property apiId API identifier.
 * @property apiMappingKey The API mapping key. Refer to [REST API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/rest-api-mappings&#46;html), [HTTP API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-mappings&#46;html) or [WebSocket API](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-mappings.html).
 * @property domainName Domain name. Use the `aws.apigatewayv2.DomainName` resource to configure a domain name.
 * @property stage API stage. Use the `aws.apigatewayv2.Stage` resource to configure an API stage.
 */
public data class ApiMappingArgs(
    public val apiId: Output<String>? = null,
    public val apiMappingKey: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val stage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.ApiMappingArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.ApiMappingArgs =
        com.pulumi.aws.apigatewayv2.ApiMappingArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiMappingKey(apiMappingKey?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .stage(stage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiMappingArgs].
 */
@PulumiTagMarker
public class ApiMappingArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiMappingKey: Output<String>? = null

    private var domainName: Output<String>? = null

    private var stage: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("ntwtuuulqntsojqv")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The API mapping key. Refer to [REST API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/rest-api-mappings&#46;html), [HTTP API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-mappings&#46;html) or [WebSocket API](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-mappings.html).
     */
    @JvmName("nencmmsbhcdgjhtq")
    public suspend fun apiMappingKey(`value`: Output<String>) {
        this.apiMappingKey = value
    }

    /**
     * @param value Domain name. Use the `aws.apigatewayv2.DomainName` resource to configure a domain name.
     */
    @JvmName("tyckkyhjqjstbjsm")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value API stage. Use the `aws.apigatewayv2.Stage` resource to configure an API stage.
     */
    @JvmName("aekxdnijwjyqqino")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("rqcwyoulfqoqtisq")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The API mapping key. Refer to [REST API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/rest-api-mappings&#46;html), [HTTP API](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-mappings&#46;html) or [WebSocket API](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-mappings.html).
     */
    @JvmName("ipllwutlvoqdiffs")
    public suspend fun apiMappingKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiMappingKey = mapped
    }

    /**
     * @param value Domain name. Use the `aws.apigatewayv2.DomainName` resource to configure a domain name.
     */
    @JvmName("jlphdeqjmpttbyru")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value API stage. Use the `aws.apigatewayv2.Stage` resource to configure an API stage.
     */
    @JvmName("hahedriqnuvvstph")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    internal fun build(): ApiMappingArgs = ApiMappingArgs(
        apiId = apiId,
        apiMappingKey = apiMappingKey,
        domainName = domainName,
        stage = stage,
    )
}
