@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions.getApiPlain
import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions.getApisPlain
import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions.getExportPlain
import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions.getVpcLinkPlain
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetApiPlainArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetApiPlainArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetApisPlainArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetApisPlainArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetExportPlainArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetExportPlainArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetVpcLinkPlainArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.GetVpcLinkPlainArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetApiResult
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetApisResult
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetExportResult
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetVpcLinkResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetApiResult.Companion.toKotlin as getApiResultToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetApisResult.Companion.toKotlin as getApisResultToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetExportResult.Companion.toKotlin as getExportResultToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.GetVpcLinkResult.Companion.toKotlin as getVpcLinkResultToKotlin

public object Apigatewayv2Functions {
    /**
     * Provides details about a specific Amazon API Gateway Version 2 API.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions;
     * import com.pulumi.aws.apigatewayv2.inputs.GetApiArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Apigatewayv2Functions.getApi(GetApiArgs.builder()
     *             .apiId("aabbccddee")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getApi.
     * @return A collection of values returned by getApi.
     */
    public suspend fun getApi(argument: GetApiPlainArgs): GetApiResult =
        getApiResultToKotlin(getApiPlain(argument.toJava()).await())

    /**
     * @see [getApi].
     * @param apiId API identifier.
     * @param tags Map of resource tags.
     * @return A collection of values returned by getApi.
     */
    public suspend fun getApi(apiId: String, tags: Map<String, String>? = null): GetApiResult {
        val argument = GetApiPlainArgs(
            apiId = apiId,
            tags = tags,
        )
        return getApiResultToKotlin(getApiPlain(argument.toJava()).await())
    }

    /**
     * @see [getApi].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigatewayv2&#46;kotlin&#46;inputs&#46;GetApiPlainArgs].
     * @return A collection of values returned by getApi.
     */
    public suspend fun getApi(argument: suspend GetApiPlainArgsBuilder.() -> Unit): GetApiResult {
        val builder = GetApiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiResultToKotlin(getApiPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple Amazon API Gateway Version 2 APIs.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions;
     * import com.pulumi.aws.apigatewayv2.inputs.GetApisArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Apigatewayv2Functions.getApis(GetApisArgs.builder()
     *             .protocolType("HTTP")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getApis.
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(argument: GetApisPlainArgs): GetApisResult =
        getApisResultToKotlin(getApisPlain(argument.toJava()).await())

    /**
     * @see [getApis].
     * @param name API name.
     * @param protocolType API protocol.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired APIs.
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(
        name: String? = null,
        protocolType: String? = null,
        tags: Map<String, String>? = null,
    ): GetApisResult {
        val argument = GetApisPlainArgs(
            name = name,
            protocolType = protocolType,
            tags = tags,
        )
        return getApisResultToKotlin(getApisPlain(argument.toJava()).await())
    }

    /**
     * @see [getApis].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigatewayv2&#46;kotlin&#46;inputs&#46;GetApisPlainArgs].
     * @return A collection of values returned by getApis.
     */
    public suspend fun getApis(argument: suspend GetApisPlainArgsBuilder.() -> Unit): GetApisResult {
        val builder = GetApisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApisResultToKotlin(getApisPlain(builtArgument.toJava()).await())
    }

    /**
     * Exports a definition of an API in a particular output format and specification.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions;
     * import com.pulumi.aws.apigatewayv2.inputs.GetExportArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Apigatewayv2Functions.getExport(GetExportArgs.builder()
     *             .apiId(aws_apigatewayv2_route.test().api_id())
     *             .specification("OAS30")
     *             .outputType("JSON")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getExport.
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: GetExportPlainArgs): GetExportResult =
        getExportResultToKotlin(getExportPlain(argument.toJava()).await())

    /**
     * @see [getExport].
     * @param apiId API identifier.
     * @param exportVersion Version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is `1.0`.
     * @param includeExtensions Whether to include API Gateway extensions in the exported API definition. API Gateway extensions are included by default.
     * @param outputType Output type of the exported definition file. Valid values are `JSON` and `YAML`.
     * @param specification Version of the API specification to use. `OAS30`, for OpenAPI 3.0, is the only supported value.
     * @param stageName Name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(
        apiId: String,
        exportVersion: String? = null,
        includeExtensions: Boolean? = null,
        outputType: String,
        specification: String,
        stageName: String? = null,
    ): GetExportResult {
        val argument = GetExportPlainArgs(
            apiId = apiId,
            exportVersion = exportVersion,
            includeExtensions = includeExtensions,
            outputType = outputType,
            specification = specification,
            stageName = stageName,
        )
        return getExportResultToKotlin(getExportPlain(argument.toJava()).await())
    }

    /**
     * @see [getExport].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigatewayv2&#46;kotlin&#46;inputs&#46;GetExportPlainArgs].
     * @return A collection of values returned by getExport.
     */
    public suspend fun getExport(argument: suspend GetExportPlainArgsBuilder.() -> Unit):
        GetExportResult {
        val builder = GetExportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportResultToKotlin(getExportPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS API Gateway V2 VPC Link.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.apigatewayv2.Apigatewayv2Functions;
     * import com.pulumi.aws.apigatewayv2.inputs.GetVpcLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Apigatewayv2Functions.getVpcLink(GetVpcLinkArgs.builder()
     *             .vpcLinkId("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcLink.
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(argument: GetVpcLinkPlainArgs): GetVpcLinkResult =
        getVpcLinkResultToKotlin(getVpcLinkPlain(argument.toJava()).await())

    /**
     * @see [getVpcLink].
     * @param tags VPC Link Tags.
     * @param vpcLinkId VPC Link ID
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(tags: Map<String, String>? = null, vpcLinkId: String):
        GetVpcLinkResult {
        val argument = GetVpcLinkPlainArgs(
            tags = tags,
            vpcLinkId = vpcLinkId,
        )
        return getVpcLinkResultToKotlin(getVpcLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;apigatewayv2&#46;kotlin&#46;inputs&#46;GetVpcLinkPlainArgs].
     * @return A collection of values returned by getVpcLink.
     */
    public suspend fun getVpcLink(argument: suspend GetVpcLinkPlainArgsBuilder.() -> Unit):
        GetVpcLinkResult {
        val builder = GetVpcLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcLinkResultToKotlin(getVpcLinkPlain(builtArgument.toJava()).await())
    }
}
