@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.AuthorizerArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.AuthorizerJwtConfigurationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.AuthorizerJwtConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 authorizer.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic WebSocket API
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Authorizer;
 * import com.pulumi.aws.apigatewayv2.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .authorizerType("REQUEST")
 *             .authorizerUri(aws_lambda_function.example().invoke_arn())
 *             .identitySources("route.request.header.Auth")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic HTTP API
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Authorizer;
 * import com.pulumi.aws.apigatewayv2.AuthorizerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Authorizer("example", AuthorizerArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .authorizerType("REQUEST")
 *             .authorizerUri(aws_lambda_function.example().invoke_arn())
 *             .identitySources("$request.header.Authorization")
 *             .authorizerPayloadFormatVersion("2.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_authorizer` using the API identifier and authorizer identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/authorizer:Authorizer example aabbccddee/1122334
 * ```
 * @property apiId API identifier.
 * @property authorizerCredentialsArn Required credentials as an IAM role for API Gateway to invoke the authorizer.
 * Supported only for `REQUEST` authorizers.
 * @property authorizerPayloadFormatVersion Format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers.
 * Valid values: `1.0`, `2.0`.
 * @property authorizerResultTtlInSeconds Time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled.
 * If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Defaults to `300`.
 * Supported only for HTTP API Lambda authorizers.
 * @property authorizerType Authorizer type. Valid values: `JWT`, `REQUEST`.
 * Specify `REQUEST` for a Lambda function using incoming request parameters.
 * For HTTP APIs, specify `JWT` to use JSON Web Tokens.
 * @property authorizerUri Authorizer's Uniform Resource Identifier (URI).
 * For `REQUEST` authorizers this must be a well-formed Lambda function URI, such as the `invoke_arn` attribute of the `aws.lambda.Function` resource.
 * Supported only for `REQUEST` authorizers. Must be between 1 and 2048 characters in length.
 * @property enableSimpleResponses Whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
 * Supported only for HTTP APIs.
 * @property identitySources Identity sources for which authorization is requested.
 * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
 * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
 * @property jwtConfiguration Configuration of a JWT authorizer. Required for the `JWT` authorizer type.
 * Supported only for HTTP APIs.
 * @property name Name of the authorizer. Must be between 1 and 128 characters in length.
 */
public data class AuthorizerArgs(
    public val apiId: Output<String>? = null,
    public val authorizerCredentialsArn: Output<String>? = null,
    public val authorizerPayloadFormatVersion: Output<String>? = null,
    public val authorizerResultTtlInSeconds: Output<Int>? = null,
    public val authorizerType: Output<String>? = null,
    public val authorizerUri: Output<String>? = null,
    public val enableSimpleResponses: Output<Boolean>? = null,
    public val identitySources: Output<List<String>>? = null,
    public val jwtConfiguration: Output<AuthorizerJwtConfigurationArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.AuthorizerArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.AuthorizerArgs =
        com.pulumi.aws.apigatewayv2.AuthorizerArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .authorizerCredentialsArn(authorizerCredentialsArn?.applyValue({ args0 -> args0 }))
            .authorizerPayloadFormatVersion(authorizerPayloadFormatVersion?.applyValue({ args0 -> args0 }))
            .authorizerResultTtlInSeconds(authorizerResultTtlInSeconds?.applyValue({ args0 -> args0 }))
            .authorizerType(authorizerType?.applyValue({ args0 -> args0 }))
            .authorizerUri(authorizerUri?.applyValue({ args0 -> args0 }))
            .enableSimpleResponses(enableSimpleResponses?.applyValue({ args0 -> args0 }))
            .identitySources(identitySources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .jwtConfiguration(jwtConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizerArgs].
 */
@PulumiTagMarker
public class AuthorizerArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var authorizerCredentialsArn: Output<String>? = null

    private var authorizerPayloadFormatVersion: Output<String>? = null

    private var authorizerResultTtlInSeconds: Output<Int>? = null

    private var authorizerType: Output<String>? = null

    private var authorizerUri: Output<String>? = null

    private var enableSimpleResponses: Output<Boolean>? = null

    private var identitySources: Output<List<String>>? = null

    private var jwtConfiguration: Output<AuthorizerJwtConfigurationArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("ogwpbxgfctwanbch")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Required credentials as an IAM role for API Gateway to invoke the authorizer.
     * Supported only for `REQUEST` authorizers.
     */
    @JvmName("itrgcapkwashpync")
    public suspend fun authorizerCredentialsArn(`value`: Output<String>) {
        this.authorizerCredentialsArn = value
    }

    /**
     * @param value Format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers.
     * Valid values: `1.0`, `2.0`.
     */
    @JvmName("tlwsjxjgxqoycbxf")
    public suspend fun authorizerPayloadFormatVersion(`value`: Output<String>) {
        this.authorizerPayloadFormatVersion = value
    }

    /**
     * @param value Time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled.
     * If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Defaults to `300`.
     * Supported only for HTTP API Lambda authorizers.
     */
    @JvmName("gkxxyiclucsafmsp")
    public suspend fun authorizerResultTtlInSeconds(`value`: Output<Int>) {
        this.authorizerResultTtlInSeconds = value
    }

    /**
     * @param value Authorizer type. Valid values: `JWT`, `REQUEST`.
     * Specify `REQUEST` for a Lambda function using incoming request parameters.
     * For HTTP APIs, specify `JWT` to use JSON Web Tokens.
     */
    @JvmName("lkasmgmpohlibyfx")
    public suspend fun authorizerType(`value`: Output<String>) {
        this.authorizerType = value
    }

    /**
     * @param value Authorizer's Uniform Resource Identifier (URI).
     * For `REQUEST` authorizers this must be a well-formed Lambda function URI, such as the `invoke_arn` attribute of the `aws.lambda.Function` resource.
     * Supported only for `REQUEST` authorizers. Must be between 1 and 2048 characters in length.
     */
    @JvmName("jikfcgqalfpboybm")
    public suspend fun authorizerUri(`value`: Output<String>) {
        this.authorizerUri = value
    }

    /**
     * @param value Whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
     * Supported only for HTTP APIs.
     */
    @JvmName("shkotmnnekimdpur")
    public suspend fun enableSimpleResponses(`value`: Output<Boolean>) {
        this.enableSimpleResponses = value
    }

    /**
     * @param value Identity sources for which authorization is requested.
     * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
     * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
     */
    @JvmName("xdsmlneantdubcyo")
    public suspend fun identitySources(`value`: Output<List<String>>) {
        this.identitySources = value
    }

    @JvmName("ryxcnvardblyckav")
    public suspend fun identitySources(vararg values: Output<String>) {
        this.identitySources = Output.all(values.asList())
    }

    /**
     * @param values Identity sources for which authorization is requested.
     * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
     * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
     */
    @JvmName("eujnkauwrnvpstdd")
    public suspend fun identitySources(values: List<Output<String>>) {
        this.identitySources = Output.all(values)
    }

    /**
     * @param value Configuration of a JWT authorizer. Required for the `JWT` authorizer type.
     * Supported only for HTTP APIs.
     */
    @JvmName("oxhwrviyaeqxbbik")
    public suspend fun jwtConfiguration(`value`: Output<AuthorizerJwtConfigurationArgs>) {
        this.jwtConfiguration = value
    }

    /**
     * @param value Name of the authorizer. Must be between 1 and 128 characters in length.
     */
    @JvmName("gpjarqkfypiwleyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("ysetarvenfykcwag")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Required credentials as an IAM role for API Gateway to invoke the authorizer.
     * Supported only for `REQUEST` authorizers.
     */
    @JvmName("fuwgochgnxoojuax")
    public suspend fun authorizerCredentialsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerCredentialsArn = mapped
    }

    /**
     * @param value Format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers.
     * Valid values: `1.0`, `2.0`.
     */
    @JvmName("uwiimumvarrbtbdd")
    public suspend fun authorizerPayloadFormatVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerPayloadFormatVersion = mapped
    }

    /**
     * @param value Time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled.
     * If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Defaults to `300`.
     * Supported only for HTTP API Lambda authorizers.
     */
    @JvmName("dknykcmsyxhwlwvf")
    public suspend fun authorizerResultTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerResultTtlInSeconds = mapped
    }

    /**
     * @param value Authorizer type. Valid values: `JWT`, `REQUEST`.
     * Specify `REQUEST` for a Lambda function using incoming request parameters.
     * For HTTP APIs, specify `JWT` to use JSON Web Tokens.
     */
    @JvmName("lrqubvkdgsauxror")
    public suspend fun authorizerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerType = mapped
    }

    /**
     * @param value Authorizer's Uniform Resource Identifier (URI).
     * For `REQUEST` authorizers this must be a well-formed Lambda function URI, such as the `invoke_arn` attribute of the `aws.lambda.Function` resource.
     * Supported only for `REQUEST` authorizers. Must be between 1 and 2048 characters in length.
     */
    @JvmName("tskpxuylnsgomiis")
    public suspend fun authorizerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerUri = mapped
    }

    /**
     * @param value Whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
     * Supported only for HTTP APIs.
     */
    @JvmName("hmeejtjvgfcokdsy")
    public suspend fun enableSimpleResponses(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSimpleResponses = mapped
    }

    /**
     * @param value Identity sources for which authorization is requested.
     * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
     * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
     */
    @JvmName("uetueqnbrpkbhesu")
    public suspend fun identitySources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identitySources = mapped
    }

    /**
     * @param values Identity sources for which authorization is requested.
     * For `REQUEST` authorizers the value is a list of one or more mapping expressions of the specified request parameters.
     * For `JWT` authorizers the single entry specifies where to extract the JSON Web Token (JWT) from inbound requests.
     */
    @JvmName("wweelsnmarpnridj")
    public suspend fun identitySources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identitySources = mapped
    }

    /**
     * @param value Configuration of a JWT authorizer. Required for the `JWT` authorizer type.
     * Supported only for HTTP APIs.
     */
    @JvmName("awsipwwjrmbewxua")
    public suspend fun jwtConfiguration(`value`: AuthorizerJwtConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jwtConfiguration = mapped
    }

    /**
     * @param argument Configuration of a JWT authorizer. Required for the `JWT` authorizer type.
     * Supported only for HTTP APIs.
     */
    @JvmName("gaefedaosojessua")
    public suspend
    fun jwtConfiguration(argument: suspend AuthorizerJwtConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizerJwtConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jwtConfiguration = mapped
    }

    /**
     * @param value Name of the authorizer. Must be between 1 and 128 characters in length.
     */
    @JvmName("ogbmcnsqjoqhpmxn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AuthorizerArgs = AuthorizerArgs(
        apiId = apiId,
        authorizerCredentialsArn = authorizerCredentialsArn,
        authorizerPayloadFormatVersion = authorizerPayloadFormatVersion,
        authorizerResultTtlInSeconds = authorizerResultTtlInSeconds,
        authorizerType = authorizerType,
        authorizerUri = authorizerUri,
        enableSimpleResponses = enableSimpleResponses,
        identitySources = identitySources,
        jwtConfiguration = jwtConfiguration,
        name = name,
    )
}
