@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.DeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 deployment.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * > **Note:** Creating a deployment for an API requires at least one `aws.apigatewayv2.Route` resource associated with that API. To avoid race conditions when all resources are being created together, you need to add implicit resource references via the `triggers` argument or explicit resource references using the [resource `dependsOn` meta-argument](https://www.pulumi.com/docs/intro/concepts/programming-model/#dependson).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Deployment;
 * import com.pulumi.aws.apigatewayv2.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Deployment("example", DeploymentArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .description("Example deployment")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_deployment` using the API identifier and deployment identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/deployment:Deployment example aabbccddee/1122334
 * ```
 *  The `triggers` argument cannot be imported.
 * @property apiId API identifier.
 * @property description Description for the deployment resource. Must be less than or equal to 1024 characters in length.
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger a redeployment.
 */
public data class DeploymentArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.DeploymentArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.DeploymentArgs =
        com.pulumi.aws.apigatewayv2.DeploymentArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("cwlcmakkanisttiq")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description for the deployment resource. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("yscxvorgwftfqlin")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("avgllfwbgtchhpeq")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("fracqrlewnfsoone")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description for the deployment resource. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("alvocgvgwpdnjece")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("bacfrlohngxiehvs")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger a redeployment.
     */
    @JvmName("ylqinttmqvfywerc")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        apiId = apiId,
        description = description,
        triggers = triggers,
    )
}
