@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.DomainNameDomainNameConfiguration
import com.pulumi.aws.apigatewayv2.kotlin.outputs.DomainNameMutualTlsAuthentication
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apigatewayv2.kotlin.outputs.DomainNameDomainNameConfiguration.Companion.toKotlin as domainNameDomainNameConfigurationToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.DomainNameMutualTlsAuthentication.Companion.toKotlin as domainNameMutualTlsAuthenticationToKotlin

/**
 * Builder for [DomainName].
 */
@PulumiTagMarker
public class DomainNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainNameArgs = DomainNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainNameArgsBuilder.() -> Unit) {
        val builder = DomainNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainName {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.DomainName(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainName(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 domain name.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * > **Note:** This resource establishes ownership of and the TLS settings for
 * a particular domain name. An API stage can be associated with the domain name using the `aws.apigatewayv2.ApiMapping` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("ws-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(aws_acm_certificate.example().arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Associated Route 53 Resource Record
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .domainName("http-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(aws_acm_certificate.example().arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .zoneId(aws_route53_zone.example().zone_id())
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(exampleDomainName.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.targetDomainName()))
 *                 .zoneId(exampleDomainName.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.hostedZoneId()))
 *                 .evaluateTargetHealth(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_domain_name` using the domain name. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/domainName:DomainName example ws-api.example.com
 * ```
 *
 */
public class DomainName internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.DomainName,
) : KotlinCustomResource(javaResource, DomainNameMapper) {
    /**
     * [API mapping selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-mapping-selection-expressions) for the domain name.
     */
    public val apiMappingSelectionExpression: Output<String>
        get() = javaResource.apiMappingSelectionExpression().applyValue({ args0 -> args0 })

    /**
     * ARN of the domain name.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Domain name. Must be between 1 and 512 characters in length.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Domain name configuration. See below.
     */
    public val domainNameConfiguration: Output<DomainNameDomainNameConfiguration>
        get() = javaResource.domainNameConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                domainNameDomainNameConfigurationToKotlin(args0)
            })
        })

    /**
     * Mutual TLS authentication configuration for the domain name.
     */
    public val mutualTlsAuthentication: Output<DomainNameMutualTlsAuthentication>?
        get() = javaResource.mutualTlsAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainNameMutualTlsAuthenticationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DomainNameMapper : ResourceMapper<DomainName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.DomainName::class == javaResource::class

    override fun map(javaResource: Resource): DomainName = DomainName(
        javaResource as
            com.pulumi.aws.apigatewayv2.DomainName,
    )
}

/**
 * @see [DomainName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainName].
 */
public suspend fun domainName(name: String, block: suspend DomainNameResourceBuilder.() -> Unit):
    DomainName {
    val builder = DomainNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainName(name: String): DomainName {
    val builder = DomainNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
