@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.DomainNameArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameDomainNameConfigurationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameDomainNameConfigurationArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameMutualTlsAuthenticationArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.DomainNameMutualTlsAuthenticationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 domain name.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * > **Note:** This resource establishes ownership of and the TLS settings for
 * a particular domain name. An API stage can be associated with the domain name using the `aws.apigatewayv2.ApiMapping` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainName("example", DomainNameArgs.builder()
 *             .domainName("ws-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(aws_acm_certificate.example().arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Associated Route 53 Resource Record
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.DomainName;
 * import com.pulumi.aws.apigatewayv2.DomainNameArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .domainName("http-api.example.com")
 *             .domainNameConfiguration(DomainNameDomainNameConfigurationArgs.builder()
 *                 .certificateArn(aws_acm_certificate.example().arn())
 *                 .endpointType("REGIONAL")
 *                 .securityPolicy("TLS_1_2")
 *                 .build())
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .zoneId(aws_route53_zone.example().zone_id())
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(exampleDomainName.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.targetDomainName()))
 *                 .zoneId(exampleDomainName.domainNameConfiguration().applyValue(domainNameConfiguration -> domainNameConfiguration.hostedZoneId()))
 *                 .evaluateTargetHealth(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_domain_name` using the domain name. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/domainName:DomainName example ws-api.example.com
 * ```
 * @property domainName Domain name. Must be between 1 and 512 characters in length.
 * @property domainNameConfiguration Domain name configuration. See below.
 * @property mutualTlsAuthentication Mutual TLS authentication configuration for the domain name.
 * @property tags Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DomainNameArgs(
    public val domainName: Output<String>? = null,
    public val domainNameConfiguration: Output<DomainNameDomainNameConfigurationArgs>? = null,
    public val mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.DomainNameArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.DomainNameArgs =
        com.pulumi.aws.apigatewayv2.DomainNameArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainNameConfiguration(
                domainNameConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mutualTlsAuthentication(
                mutualTlsAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainNameArgs].
 */
@PulumiTagMarker
public class DomainNameArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var domainNameConfiguration: Output<DomainNameDomainNameConfigurationArgs>? = null

    private var mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Domain name. Must be between 1 and 512 characters in length.
     */
    @JvmName("kieyuguiknqrbxai")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Domain name configuration. See below.
     */
    @JvmName("dcomynkpsoalfbqw")
    public suspend
    fun domainNameConfiguration(`value`: Output<DomainNameDomainNameConfigurationArgs>) {
        this.domainNameConfiguration = value
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("bqhbuxwpkucswdew")
    public suspend
    fun mutualTlsAuthentication(`value`: Output<DomainNameMutualTlsAuthenticationArgs>) {
        this.mutualTlsAuthentication = value
    }

    /**
     * @param value Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xspvyiuefguaewln")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Domain name. Must be between 1 and 512 characters in length.
     */
    @JvmName("txktpygmmoubjjgb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Domain name configuration. See below.
     */
    @JvmName("ugeaptovnemivynq")
    public suspend fun domainNameConfiguration(`value`: DomainNameDomainNameConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameConfiguration = mapped
    }

    /**
     * @param argument Domain name configuration. See below.
     */
    @JvmName("mdpdqiarskukfdgc")
    public suspend
    fun domainNameConfiguration(argument: suspend DomainNameDomainNameConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameDomainNameConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.domainNameConfiguration = mapped
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("qfkgyifpfhqliewp")
    public suspend fun mutualTlsAuthentication(`value`: DomainNameMutualTlsAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param argument Mutual TLS authentication configuration for the domain name.
     */
    @JvmName("yhgjhmrjnrwdmlnk")
    public suspend
    fun mutualTlsAuthentication(argument: suspend DomainNameMutualTlsAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameMutualTlsAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param value Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("viigvjwhkytngxdn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the domain name. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fgwersvsbnyyaobu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainNameArgs = DomainNameArgs(
        domainName = domainName,
        domainNameConfiguration = domainNameConfiguration,
        mutualTlsAuthentication = mutualTlsAuthentication,
        tags = tags,
    )
}
