@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.IntegrationResponseParameter
import com.pulumi.aws.apigatewayv2.kotlin.outputs.IntegrationTlsConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.apigatewayv2.kotlin.outputs.IntegrationResponseParameter.Companion.toKotlin as integrationResponseParameterToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.IntegrationTlsConfig.Companion.toKotlin as integrationTlsConfigToKotlin

/**
 * Builder for [Integration].
 */
@PulumiTagMarker
public class IntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationArgs = IntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationArgsBuilder.() -> Unit) {
        val builder = IntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Integration {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Integration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Integration(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 integration.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationType("MOCK")
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .code(new FileArchive("example.zip"))
 *             .role(aws_iam_role.example().arn())
 *             .handler("index.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationType("AWS_PROXY")
 *             .connectionType("INTERNET")
 *             .contentHandlingStrategy("CONVERT_TO_TEXT")
 *             .description("Lambda example")
 *             .integrationMethod("POST")
 *             .integrationUri(exampleFunction.invokeArn())
 *             .passthroughBehavior("WHEN_NO_MATCH")
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Service Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .credentialsArn(aws_iam_role.example().arn())
 *             .description("SQS example")
 *             .integrationType("AWS_PROXY")
 *             .integrationSubtype("SQS-SendMessage")
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry("QueueUrl", "$request.header.queueUrl"),
 *                 Map.entry("MessageBody", "$request.body.message")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Private Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .credentialsArn(aws_iam_role.example().arn())
 *             .description("Example with a load balancer")
 *             .integrationType("HTTP_PROXY")
 *             .integrationUri(aws_lb_listener.example().arn())
 *             .integrationMethod("ANY")
 *             .connectionType("VPC_LINK")
 *             .connectionId(aws_apigatewayv2_vpc_link.example().id())
 *             .tlsConfig(IntegrationTlsConfigArgs.builder()
 *                 .serverNameToVerify("example.com")
 *                 .build())
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry("append:header.authforintegration", "$context.authorizer.authorizerResponse"),
 *                 Map.entry("overwrite:path", "staticValueForIntegration")
 *             ))
 *             .responseParameters(
 *                 IntegrationResponseParameterArgs.builder()
 *                     .statusCode(403)
 *                     .mappings(Map.of("append:header.auth", "$context.authorizer.authorizerResponse"))
 *                     .build(),
 *                 IntegrationResponseParameterArgs.builder()
 *                     .statusCode(200)
 *                     .mappings(Map.of("overwrite:statuscode", "204"))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration` using the API identifier and integration identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/integration:Integration example aabbccddee/1122334
 * ```
 *  -> __Note:__ The API Gateway managed integration created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 */
public class Integration internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Integration,
) : KotlinCustomResource(javaResource, IntegrationMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
     */
    public val connectionId: Output<String>?
        get() = javaResource.connectionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
     */
    public val connectionType: Output<String>?
        get() = javaResource.connectionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
     */
    public val contentHandlingStrategy: Output<String>?
        get() = javaResource.contentHandlingStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Credentials required for the integration, if any.
     */
    public val credentialsArn: Output<String>?
        get() = javaResource.credentialsArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the integration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
     */
    public val integrationMethod: Output<String>?
        get() = javaResource.integrationMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
     */
    public val integrationResponseSelectionExpression: Output<String>
        get() = javaResource.integrationResponseSelectionExpression().applyValue({ args0 -> args0 })

    /**
     * AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
     */
    public val integrationSubtype: Output<String>?
        get() = javaResource.integrationSubtype().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Integration type of an integration.
     * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
     */
    public val integrationType: Output<String>
        get() = javaResource.integrationType().applyValue({ args0 -> args0 })

    /**
     * URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
     * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
     */
    public val integrationUri: Output<String>?
        get() = javaResource.integrationUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
     * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
     */
    public val passthroughBehavior: Output<String>?
        get() = javaResource.passthroughBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
     */
    public val payloadFormatVersion: Output<String>?
        get() = javaResource.payloadFormatVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    public val requestParameters: Output<Map<String, String>>?
        get() = javaResource.requestParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     */
    public val requestTemplates: Output<Map<String, String>>?
        get() = javaResource.requestTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    public val responseParameters: Output<List<IntegrationResponseParameter>>?
        get() = javaResource.responseParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        integrationResponseParameterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
     */
    public val templateSelectionExpression: Output<String>?
        get() = javaResource.templateSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * this provider will only perform drift detection of its value when present in a configuration.
     */
    public val timeoutMilliseconds: Output<Int>
        get() = javaResource.timeoutMilliseconds().applyValue({ args0 -> args0 })

    /**
     * TLS configuration for a private integration. Supported only for HTTP APIs.
     */
    public val tlsConfig: Output<IntegrationTlsConfig>?
        get() = javaResource.tlsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    integrationTlsConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object IntegrationMapper : ResourceMapper<Integration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Integration::class == javaResource::class

    override fun map(javaResource: Resource): Integration = Integration(
        javaResource as
            com.pulumi.aws.apigatewayv2.Integration,
    )
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Integration].
 */
public suspend fun integration(name: String, block: suspend IntegrationResourceBuilder.() -> Unit):
    Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integration(name: String): Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
