@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.IntegrationArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.IntegrationResponseParameterArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.IntegrationResponseParameterArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.IntegrationTlsConfigArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.IntegrationTlsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 integration.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationType("MOCK")
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .code(new FileArchive("example.zip"))
 *             .role(aws_iam_role.example().arn())
 *             .handler("index.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationType("AWS_PROXY")
 *             .connectionType("INTERNET")
 *             .contentHandlingStrategy("CONVERT_TO_TEXT")
 *             .description("Lambda example")
 *             .integrationMethod("POST")
 *             .integrationUri(exampleFunction.invokeArn())
 *             .passthroughBehavior("WHEN_NO_MATCH")
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Service Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .credentialsArn(aws_iam_role.example().arn())
 *             .description("SQS example")
 *             .integrationType("AWS_PROXY")
 *             .integrationSubtype("SQS-SendMessage")
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry("QueueUrl", "$request.header.queueUrl"),
 *                 Map.entry("MessageBody", "$request.body.message")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Private Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs;
 * import com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Integration("example", IntegrationArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .credentialsArn(aws_iam_role.example().arn())
 *             .description("Example with a load balancer")
 *             .integrationType("HTTP_PROXY")
 *             .integrationUri(aws_lb_listener.example().arn())
 *             .integrationMethod("ANY")
 *             .connectionType("VPC_LINK")
 *             .connectionId(aws_apigatewayv2_vpc_link.example().id())
 *             .tlsConfig(IntegrationTlsConfigArgs.builder()
 *                 .serverNameToVerify("example.com")
 *                 .build())
 *             .requestParameters(Map.ofEntries(
 *                 Map.entry("append:header.authforintegration", "$context.authorizer.authorizerResponse"),
 *                 Map.entry("overwrite:path", "staticValueForIntegration")
 *             ))
 *             .responseParameters(
 *                 IntegrationResponseParameterArgs.builder()
 *                     .statusCode(403)
 *                     .mappings(Map.of("append:header.auth", "$context.authorizer.authorizerResponse"))
 *                     .build(),
 *                 IntegrationResponseParameterArgs.builder()
 *                     .statusCode(200)
 *                     .mappings(Map.of("overwrite:statuscode", "204"))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration` using the API identifier and integration identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/integration:Integration example aabbccddee/1122334
 * ```
 *  -> __Note:__ The API Gateway managed integration created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 * @property apiId API identifier.
 * @property connectionId ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
 * @property connectionType Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
 * @property contentHandlingStrategy How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
 * @property credentialsArn Credentials required for the integration, if any.
 * @property description Description of the integration.
 * @property integrationMethod Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
 * @property integrationSubtype AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
 * @property integrationType Integration type of an integration.
 * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
 * @property integrationUri URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
 * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
 * @property passthroughBehavior Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
 * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
 * @property payloadFormatVersion The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
 * @property requestParameters For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
 * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
 * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
 * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
 * @property requestTemplates Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
 * @property responseParameters Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
 * @property templateSelectionExpression The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
 * @property timeoutMilliseconds Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
 * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
 * this provider will only perform drift detection of its value when present in a configuration.
 * @property tlsConfig TLS configuration for a private integration. Supported only for HTTP APIs.
 */
public data class IntegrationArgs(
    public val apiId: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val connectionType: Output<String>? = null,
    public val contentHandlingStrategy: Output<String>? = null,
    public val credentialsArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val integrationMethod: Output<String>? = null,
    public val integrationSubtype: Output<String>? = null,
    public val integrationType: Output<String>? = null,
    public val integrationUri: Output<String>? = null,
    public val passthroughBehavior: Output<String>? = null,
    public val payloadFormatVersion: Output<String>? = null,
    public val requestParameters: Output<Map<String, String>>? = null,
    public val requestTemplates: Output<Map<String, String>>? = null,
    public val responseParameters: Output<List<IntegrationResponseParameterArgs>>? = null,
    public val templateSelectionExpression: Output<String>? = null,
    public val timeoutMilliseconds: Output<Int>? = null,
    public val tlsConfig: Output<IntegrationTlsConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.IntegrationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.IntegrationArgs =
        com.pulumi.aws.apigatewayv2.IntegrationArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .connectionType(connectionType?.applyValue({ args0 -> args0 }))
            .contentHandlingStrategy(contentHandlingStrategy?.applyValue({ args0 -> args0 }))
            .credentialsArn(credentialsArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .integrationMethod(integrationMethod?.applyValue({ args0 -> args0 }))
            .integrationSubtype(integrationSubtype?.applyValue({ args0 -> args0 }))
            .integrationType(integrationType?.applyValue({ args0 -> args0 }))
            .integrationUri(integrationUri?.applyValue({ args0 -> args0 }))
            .passthroughBehavior(passthroughBehavior?.applyValue({ args0 -> args0 }))
            .payloadFormatVersion(payloadFormatVersion?.applyValue({ args0 -> args0 }))
            .requestParameters(
                requestParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .requestTemplates(
                requestTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseParameters(
                responseParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .templateSelectionExpression(templateSelectionExpression?.applyValue({ args0 -> args0 }))
            .timeoutMilliseconds(timeoutMilliseconds?.applyValue({ args0 -> args0 }))
            .tlsConfig(tlsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IntegrationArgs].
 */
@PulumiTagMarker
public class IntegrationArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var connectionType: Output<String>? = null

    private var contentHandlingStrategy: Output<String>? = null

    private var credentialsArn: Output<String>? = null

    private var description: Output<String>? = null

    private var integrationMethod: Output<String>? = null

    private var integrationSubtype: Output<String>? = null

    private var integrationType: Output<String>? = null

    private var integrationUri: Output<String>? = null

    private var passthroughBehavior: Output<String>? = null

    private var payloadFormatVersion: Output<String>? = null

    private var requestParameters: Output<Map<String, String>>? = null

    private var requestTemplates: Output<Map<String, String>>? = null

    private var responseParameters: Output<List<IntegrationResponseParameterArgs>>? = null

    private var templateSelectionExpression: Output<String>? = null

    private var timeoutMilliseconds: Output<Int>? = null

    private var tlsConfig: Output<IntegrationTlsConfigArgs>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("ciaodkxeadulufdm")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
     */
    @JvmName("eheranpjgfkkmdyq")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
     */
    @JvmName("wxvregfcfflavmcx")
    public suspend fun connectionType(`value`: Output<String>) {
        this.connectionType = value
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
     */
    @JvmName("dbrgxghgrvbsnpux")
    public suspend fun contentHandlingStrategy(`value`: Output<String>) {
        this.contentHandlingStrategy = value
    }

    /**
     * @param value Credentials required for the integration, if any.
     */
    @JvmName("panmdaayfdmmemib")
    public suspend fun credentialsArn(`value`: Output<String>) {
        this.credentialsArn = value
    }

    /**
     * @param value Description of the integration.
     */
    @JvmName("fbvmaoimmerdeede")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
     */
    @JvmName("yidsqoerajexjkyo")
    public suspend fun integrationMethod(`value`: Output<String>) {
        this.integrationMethod = value
    }

    /**
     * @param value AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
     */
    @JvmName("jpdxbwpputvbonhu")
    public suspend fun integrationSubtype(`value`: Output<String>) {
        this.integrationSubtype = value
    }

    /**
     * @param value Integration type of an integration.
     * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
     */
    @JvmName("bcodrmqmyerfwacy")
    public suspend fun integrationType(`value`: Output<String>) {
        this.integrationType = value
    }

    /**
     * @param value URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
     * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
     */
    @JvmName("hdnqdhucqoobiqso")
    public suspend fun integrationUri(`value`: Output<String>) {
        this.integrationUri = value
    }

    /**
     * @param value Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
     * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
     */
    @JvmName("jbdjojpenkdwwkfh")
    public suspend fun passthroughBehavior(`value`: Output<String>) {
        this.passthroughBehavior = value
    }

    /**
     * @param value The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
     */
    @JvmName("daqgjimvaidonotj")
    public suspend fun payloadFormatVersion(`value`: Output<String>) {
        this.payloadFormatVersion = value
    }

    /**
     * @param value For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("xbcdrnheekiyjuba")
    public suspend fun requestParameters(`value`: Output<Map<String, String>>) {
        this.requestParameters = value
    }

    /**
     * @param value Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     */
    @JvmName("xsdpoahuxoqwalsk")
    public suspend fun requestTemplates(`value`: Output<Map<String, String>>) {
        this.requestTemplates = value
    }

    /**
     * @param value Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("udbfldgircxbxard")
    public suspend fun responseParameters(`value`: Output<List<IntegrationResponseParameterArgs>>) {
        this.responseParameters = value
    }

    @JvmName("hjpyohrlocasxvqt")
    public suspend fun responseParameters(vararg values: Output<IntegrationResponseParameterArgs>) {
        this.responseParameters = Output.all(values.asList())
    }

    /**
     * @param values Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("moujovbdhinnqgpg")
    public suspend fun responseParameters(values: List<Output<IntegrationResponseParameterArgs>>) {
        this.responseParameters = Output.all(values)
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
     */
    @JvmName("imkytdttdpfgwxph")
    public suspend fun templateSelectionExpression(`value`: Output<String>) {
        this.templateSelectionExpression = value
    }

    /**
     * @param value Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * this provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("tqivjusdyurwvxwx")
    public suspend fun timeoutMilliseconds(`value`: Output<Int>) {
        this.timeoutMilliseconds = value
    }

    /**
     * @param value TLS configuration for a private integration. Supported only for HTTP APIs.
     */
    @JvmName("fjteimbbmwlsljnf")
    public suspend fun tlsConfig(`value`: Output<IntegrationTlsConfigArgs>) {
        this.tlsConfig = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("xnwkgdviixfavdsd")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
     */
    @JvmName("brndbeumuamyvmeq")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
     */
    @JvmName("hkmhqmjbvfkvhxic")
    public suspend fun connectionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
     */
    @JvmName("onjqcqxfgyfgwptr")
    public suspend fun contentHandlingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHandlingStrategy = mapped
    }

    /**
     * @param value Credentials required for the integration, if any.
     */
    @JvmName("gwqigckdegmofyud")
    public suspend fun credentialsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsArn = mapped
    }

    /**
     * @param value Description of the integration.
     */
    @JvmName("atcnkwvupstqfkto")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
     */
    @JvmName("lhyspfnoeodxhdfd")
    public suspend fun integrationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationMethod = mapped
    }

    /**
     * @param value AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
     */
    @JvmName("btbuwianrdqhmwwv")
    public suspend fun integrationSubtype(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationSubtype = mapped
    }

    /**
     * @param value Integration type of an integration.
     * Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
     */
    @JvmName("kwcolbybtpwsjeyg")
    public suspend fun integrationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationType = mapped
    }

    /**
     * @param value URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
     * For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
     */
    @JvmName("ebskxhftsxmfadlx")
    public suspend fun integrationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationUri = mapped
    }

    /**
     * @param value Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
     * Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
     */
    @JvmName("boofrmwyyawtqcyq")
    public suspend fun passthroughBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passthroughBehavior = mapped
    }

    /**
     * @param value The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
     */
    @JvmName("xqrpoomyxcekosui")
    public suspend fun payloadFormatVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payloadFormatVersion = mapped
    }

    /**
     * @param value For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("hmhoekspqmdmjyfe")
    public suspend fun requestParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param values For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
     * For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("ubtednykqhgeodpd")
    public fun requestParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param value Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     */
    @JvmName("byuvolmewxqbbyef")
    public suspend fun requestTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTemplates = mapped
    }

    /**
     * @param values Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
     */
    @JvmName("xwixwtugkpxgiaoy")
    public fun requestTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestTemplates = mapped
    }

    /**
     * @param value Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("jrdvcnyxykhovqsf")
    public suspend fun responseParameters(`value`: List<IntegrationResponseParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param argument Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("uvpagbefqaayevbv")
    public suspend
    fun responseParameters(argument: List<suspend IntegrationResponseParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntegrationResponseParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseParameters = mapped
    }

    /**
     * @param argument Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("rmugwnhxqecmabqi")
    public suspend fun responseParameters(
        vararg
        argument: suspend IntegrationResponseParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntegrationResponseParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseParameters = mapped
    }

    /**
     * @param argument Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("aecjpfmesrcjmbos")
    public suspend
    fun responseParameters(argument: suspend IntegrationResponseParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntegrationResponseParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.responseParameters = mapped
    }

    /**
     * @param values Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
     */
    @JvmName("wbowlynlivvhhhql")
    public suspend fun responseParameters(vararg values: IntegrationResponseParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
     */
    @JvmName("kajygqhhmpxlcakj")
    public suspend fun templateSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSelectionExpression = mapped
    }

    /**
     * @param value Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     * this provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("qxcmqnhcikaddonh")
    public suspend fun timeoutMilliseconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutMilliseconds = mapped
    }

    /**
     * @param value TLS configuration for a private integration. Supported only for HTTP APIs.
     */
    @JvmName("ccwigefhnfiajhxk")
    public suspend fun tlsConfig(`value`: IntegrationTlsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsConfig = mapped
    }

    /**
     * @param argument TLS configuration for a private integration. Supported only for HTTP APIs.
     */
    @JvmName("tycjvgxxfnxxvutf")
    public suspend fun tlsConfig(argument: suspend IntegrationTlsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationTlsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tlsConfig = mapped
    }

    internal fun build(): IntegrationArgs = IntegrationArgs(
        apiId = apiId,
        connectionId = connectionId,
        connectionType = connectionType,
        contentHandlingStrategy = contentHandlingStrategy,
        credentialsArn = credentialsArn,
        description = description,
        integrationMethod = integrationMethod,
        integrationSubtype = integrationSubtype,
        integrationType = integrationType,
        integrationUri = integrationUri,
        passthroughBehavior = passthroughBehavior,
        payloadFormatVersion = payloadFormatVersion,
        requestParameters = requestParameters,
        requestTemplates = requestTemplates,
        responseParameters = responseParameters,
        templateSelectionExpression = templateSelectionExpression,
        timeoutMilliseconds = timeoutMilliseconds,
        tlsConfig = tlsConfig,
    )
}
