@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationResponse].
 */
@PulumiTagMarker
public class IntegrationResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationResponseArgs = IntegrationResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationResponseArgsBuilder.() -> Unit) {
        val builder = IntegrationResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationResponse {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.IntegrationResponse(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IntegrationResponse(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 integration response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponse;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IntegrationResponse("example", IntegrationResponseArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationId(aws_apigatewayv2_integration.example().id())
 *             .integrationResponseKey("/200/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration_response` using the API identifier, integration identifier and integration response identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/integrationResponse:IntegrationResponse example aabbccddee/1122334/998877
 * ```
 *
 */
public class IntegrationResponse internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.IntegrationResponse,
) : KotlinCustomResource(javaResource, IntegrationResponseMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    public val contentHandlingStrategy: Output<String>?
        get() = javaResource.contentHandlingStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the `aws.apigatewayv2.Integration`.
     */
    public val integrationId: Output<String>
        get() = javaResource.integrationId().applyValue({ args0 -> args0 })

    /**
     * Integration response key.
     */
    public val integrationResponseKey: Output<String>
        get() = javaResource.integrationResponseKey().applyValue({ args0 -> args0 })

    /**
     * Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    public val responseTemplates: Output<Map<String, String>>?
        get() = javaResource.responseTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    public val templateSelectionExpression: Output<String>?
        get() = javaResource.templateSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object IntegrationResponseMapper : ResourceMapper<IntegrationResponse> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.IntegrationResponse::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationResponse = IntegrationResponse(
        javaResource
            as com.pulumi.aws.apigatewayv2.IntegrationResponse,
    )
}

/**
 * @see [IntegrationResponse].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationResponse].
 */
public suspend fun integrationResponse(
    name: String,
    block: suspend IntegrationResponseResourceBuilder.() -> Unit,
): IntegrationResponse {
    val builder = IntegrationResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationResponse].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationResponse(name: String): IntegrationResponse {
    val builder = IntegrationResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
