@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 integration response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponse;
 * import com.pulumi.aws.apigatewayv2.IntegrationResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IntegrationResponse("example", IntegrationResponseArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .integrationId(aws_apigatewayv2_integration.example().id())
 *             .integrationResponseKey("/200/")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_integration_response` using the API identifier, integration identifier and integration response identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/integrationResponse:IntegrationResponse example aabbccddee/1122334/998877
 * ```
 * @property apiId API identifier.
 * @property contentHandlingStrategy How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
 * @property integrationId Identifier of the `aws.apigatewayv2.Integration`.
 * @property integrationResponseKey Integration response key.
 * @property responseTemplates Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
 * @property templateSelectionExpression The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
 */
public data class IntegrationResponseArgs(
    public val apiId: Output<String>? = null,
    public val contentHandlingStrategy: Output<String>? = null,
    public val integrationId: Output<String>? = null,
    public val integrationResponseKey: Output<String>? = null,
    public val responseTemplates: Output<Map<String, String>>? = null,
    public val templateSelectionExpression: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.IntegrationResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.IntegrationResponseArgs =
        com.pulumi.aws.apigatewayv2.IntegrationResponseArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .contentHandlingStrategy(contentHandlingStrategy?.applyValue({ args0 -> args0 }))
            .integrationId(integrationId?.applyValue({ args0 -> args0 }))
            .integrationResponseKey(integrationResponseKey?.applyValue({ args0 -> args0 }))
            .responseTemplates(
                responseTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .templateSelectionExpression(templateSelectionExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationResponseArgs].
 */
@PulumiTagMarker
public class IntegrationResponseArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var contentHandlingStrategy: Output<String>? = null

    private var integrationId: Output<String>? = null

    private var integrationResponseKey: Output<String>? = null

    private var responseTemplates: Output<Map<String, String>>? = null

    private var templateSelectionExpression: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("mjcwgrdmuxqmdcuw")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    @JvmName("dbepbuwggadxfwhv")
    public suspend fun contentHandlingStrategy(`value`: Output<String>) {
        this.contentHandlingStrategy = value
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Integration`.
     */
    @JvmName("txwcuardmrgwdqgw")
    public suspend fun integrationId(`value`: Output<String>) {
        this.integrationId = value
    }

    /**
     * @param value Integration response key.
     */
    @JvmName("ifgewbaaxvbvuyen")
    public suspend fun integrationResponseKey(`value`: Output<String>) {
        this.integrationResponseKey = value
    }

    /**
     * @param value Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("gslensiibyqcxmtx")
    public suspend fun responseTemplates(`value`: Output<Map<String, String>>) {
        this.responseTemplates = value
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    @JvmName("qcwtustastwqmnpl")
    public suspend fun templateSelectionExpression(`value`: Output<String>) {
        this.templateSelectionExpression = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("ussvninupnxcvhdh")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`.
     */
    @JvmName("pcwbaxslgcunnidk")
    public suspend fun contentHandlingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHandlingStrategy = mapped
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Integration`.
     */
    @JvmName("siegdxdgtahoaxnu")
    public suspend fun integrationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationId = mapped
    }

    /**
     * @param value Integration response key.
     */
    @JvmName("mrvivnhxsslnfxsl")
    public suspend fun integrationResponseKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationResponseKey = mapped
    }

    /**
     * @param value Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("eivolrcdhktvdusv")
    public suspend fun responseTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param values Map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     */
    @JvmName("phpjexmwovgletqa")
    public fun responseTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param value The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration response.
     */
    @JvmName("keorpyvnouisuyit")
    public suspend fun templateSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSelectionExpression = mapped
    }

    internal fun build(): IntegrationResponseArgs = IntegrationResponseArgs(
        apiId = apiId,
        contentHandlingStrategy = contentHandlingStrategy,
        integrationId = integrationId,
        integrationResponseKey = integrationResponseKey,
        responseTemplates = responseTemplates,
        templateSelectionExpression = templateSelectionExpression,
    )
}
