@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 [model](https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-models).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Model;
 * import com.pulumi.aws.apigatewayv2.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Model("example", ModelArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("$schema", "http://json-schema.org/draft-04/schema#"),
 *                     jsonProperty("title", "ExampleModel"),
 *                     jsonProperty("type", "object"),
 *                     jsonProperty("properties", jsonObject(
 *                         jsonProperty("id", jsonObject(
 *                             jsonProperty("type", "string")
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_model` using the API identifier and model identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/model:Model example aabbccddee/1122334
 * ```
 *
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Description of the model. Must be between 1 and 128 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    public val schema: Output<String>
        get() = javaResource.schema().applyValue({ args0 -> args0 })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.aws.apigatewayv2.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
