@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.ModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 [model](https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-models).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Model;
 * import com.pulumi.aws.apigatewayv2.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Model("example", ModelArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("$schema", "http://json-schema.org/draft-04/schema#"),
 *                     jsonProperty("title", "ExampleModel"),
 *                     jsonProperty("type", "object"),
 *                     jsonProperty("properties", jsonObject(
 *                         jsonProperty("id", jsonObject(
 *                             jsonProperty("type", "string")
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_model` using the API identifier and model identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/model:Model example aabbccddee/1122334
 * ```
 * @property apiId API identifier.
 * @property contentType The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
 * @property description Description of the model. Must be between 1 and 128 characters in length.
 * @property name Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
 * @property schema Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
 */
public data class ModelArgs(
    public val apiId: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.ModelArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.ModelArgs =
        com.pulumi.aws.apigatewayv2.ModelArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("cbvcwgtxuarbvypw")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    @JvmName("flgioafjftilfryi")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the model. Must be between 1 and 128 characters in length.
     */
    @JvmName("bomfgvbxjhthdbea")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    @JvmName("ejmugckgjhvpqfgm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    @JvmName("gtdbfknbditmmexi")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("ltplfmkdqflbtbpq")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The content-type for the model, for example, `application/json`. Must be between 1 and 256 characters in length.
     */
    @JvmName("tqijgqcgqtmtxdds")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the model. Must be between 1 and 128 characters in length.
     */
    @JvmName("gcoixomtomfqumam")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the model. Must be alphanumeric. Must be between 1 and 128 characters in length.
     */
    @JvmName("mecxdxvqtgvnxvmd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema for the model. This should be a [JSON schema draft 4](https://tools.ietf.org/html/draft-zyp-json-schema-04) model. Must be less than or equal to 32768 characters in length.
     */
    @JvmName("lwimygyviwiarchu")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        apiId = apiId,
        contentType = contentType,
        description = description,
        name = name,
        schema = schema,
    )
}
