@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.RouteArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.RouteRequestParameterArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.RouteRequestParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 route.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/welcome&#46;html) for [WebSocket](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/websocket-api-develop-routes&#46;html) and [HTTP](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html) APIs.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApi = new Api("exampleApi", ApiArgs.builder()
 *             .protocolType("WEBSOCKET")
 *             .routeSelectionExpression("$request.body.action")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(exampleApi.id())
 *             .routeKey("$default")
 *             .build());
 *     }
 * }
 * ```
 * ### HTTP Proxy Integration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Api;
 * import com.pulumi.aws.apigatewayv2.ApiArgs;
 * import com.pulumi.aws.apigatewayv2.Integration;
 * import com.pulumi.aws.apigatewayv2.IntegrationArgs;
 * import com.pulumi.aws.apigatewayv2.Route;
 * import com.pulumi.aws.apigatewayv2.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApi = new Api("exampleApi", ApiArgs.builder()
 *             .protocolType("HTTP")
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .apiId(exampleApi.id())
 *             .integrationType("HTTP_PROXY")
 *             .integrationMethod("ANY")
 *             .integrationUri("https://example.com/{proxy}")
 *             .build());
 *         var exampleRoute = new Route("exampleRoute", RouteArgs.builder()
 *             .apiId(exampleApi.id())
 *             .routeKey("ANY /example/{proxy+}")
 *             .target(exampleIntegration.id().applyValue(id -> String.format("integrations/%s", id)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_route` using the API identifier and route identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/route:Route example aabbccddee/1122334
 * ```
 *  -> __Note:__ The API Gateway managed route created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 * @property apiId API identifier.
 * @property apiKeyRequired Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
 * @property authorizationScopes Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
 * @property authorizationType Authorization type for the route.
 * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
 * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
 * Defaults to `NONE`.
 * @property authorizerId Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
 * @property modelSelectionExpression The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
 * @property operationName Operation name for the route. Must be between 1 and 64 characters in length.
 * @property requestModels Request models for the route. Supported only for WebSocket APIs.
 * @property requestParameters Request parameters for the route. Supported only for WebSocket APIs.
 * @property routeKey Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
 * @property routeResponseSelectionExpression The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
 * @property target Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
 */
public data class RouteArgs(
    public val apiId: Output<String>? = null,
    public val apiKeyRequired: Output<Boolean>? = null,
    public val authorizationScopes: Output<List<String>>? = null,
    public val authorizationType: Output<String>? = null,
    public val authorizerId: Output<String>? = null,
    public val modelSelectionExpression: Output<String>? = null,
    public val operationName: Output<String>? = null,
    public val requestModels: Output<Map<String, String>>? = null,
    public val requestParameters: Output<List<RouteRequestParameterArgs>>? = null,
    public val routeKey: Output<String>? = null,
    public val routeResponseSelectionExpression: Output<String>? = null,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.RouteArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.RouteArgs =
        com.pulumi.aws.apigatewayv2.RouteArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiKeyRequired(apiKeyRequired?.applyValue({ args0 -> args0 }))
            .authorizationScopes(authorizationScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authorizationType(authorizationType?.applyValue({ args0 -> args0 }))
            .authorizerId(authorizerId?.applyValue({ args0 -> args0 }))
            .modelSelectionExpression(modelSelectionExpression?.applyValue({ args0 -> args0 }))
            .operationName(operationName?.applyValue({ args0 -> args0 }))
            .requestModels(
                requestModels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .requestParameters(
                requestParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .routeKey(routeKey?.applyValue({ args0 -> args0 }))
            .routeResponseSelectionExpression(routeResponseSelectionExpression?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiKeyRequired: Output<Boolean>? = null

    private var authorizationScopes: Output<List<String>>? = null

    private var authorizationType: Output<String>? = null

    private var authorizerId: Output<String>? = null

    private var modelSelectionExpression: Output<String>? = null

    private var operationName: Output<String>? = null

    private var requestModels: Output<Map<String, String>>? = null

    private var requestParameters: Output<List<RouteRequestParameterArgs>>? = null

    private var routeKey: Output<String>? = null

    private var routeResponseSelectionExpression: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("sdlcmqghspdnyagp")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("psrenmwpdrcgnbmm")
    public suspend fun apiKeyRequired(`value`: Output<Boolean>) {
        this.apiKeyRequired = value
    }

    /**
     * @param value Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("rtadwyrquwolirgt")
    public suspend fun authorizationScopes(`value`: Output<List<String>>) {
        this.authorizationScopes = value
    }

    @JvmName("omqkijfgelfahqur")
    public suspend fun authorizationScopes(vararg values: Output<String>) {
        this.authorizationScopes = Output.all(values.asList())
    }

    /**
     * @param values Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("ekjojmavukkcxnjp")
    public suspend fun authorizationScopes(values: List<Output<String>>) {
        this.authorizationScopes = Output.all(values)
    }

    /**
     * @param value Authorization type for the route.
     * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * Defaults to `NONE`.
     */
    @JvmName("mgshtnhxfaktfdox")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
     */
    @JvmName("fxqcdgnovwdijdhm")
    public suspend fun authorizerId(`value`: Output<String>) {
        this.authorizerId = value
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("aytxgilcqqeifwee")
    public suspend fun modelSelectionExpression(`value`: Output<String>) {
        this.modelSelectionExpression = value
    }

    /**
     * @param value Operation name for the route. Must be between 1 and 64 characters in length.
     */
    @JvmName("lnxjtaiebmqsfsnj")
    public suspend fun operationName(`value`: Output<String>) {
        this.operationName = value
    }

    /**
     * @param value Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("felheqqcyeqlamjw")
    public suspend fun requestModels(`value`: Output<Map<String, String>>) {
        this.requestModels = value
    }

    /**
     * @param value Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("gmupwdgyufjoajwr")
    public suspend fun requestParameters(`value`: Output<List<RouteRequestParameterArgs>>) {
        this.requestParameters = value
    }

    @JvmName("lvtdrmiknyoprytc")
    public suspend fun requestParameters(vararg values: Output<RouteRequestParameterArgs>) {
        this.requestParameters = Output.all(values.asList())
    }

    /**
     * @param values Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("kvweoxliwdcnwdhd")
    public suspend fun requestParameters(values: List<Output<RouteRequestParameterArgs>>) {
        this.requestParameters = Output.all(values)
    }

    /**
     * @param value Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
     */
    @JvmName("egudmprtecyfjykp")
    public suspend fun routeKey(`value`: Output<String>) {
        this.routeKey = value
    }

    /**
     * @param value The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("ofvtglkhjqhviosl")
    public suspend fun routeResponseSelectionExpression(`value`: Output<String>) {
        this.routeResponseSelectionExpression = value
    }

    /**
     * @param value Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
     */
    @JvmName("qmvqrvffwumjrhxl")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("rcytrtlsgkmpoimd")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Boolean whether an API key is required for the route. Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("tbiklfjvuqqajswv")
    public suspend fun apiKeyRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyRequired = mapped
    }

    /**
     * @param value Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("jrqpokyteldyfill")
    public suspend fun authorizationScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationScopes = mapped
    }

    /**
     * @param values Authorization scopes supported by this route. The scopes are used with a JWT authorizer to authorize the method invocation.
     */
    @JvmName("ypijnqcuygylsapu")
    public suspend fun authorizationScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationScopes = mapped
    }

    /**
     * @param value Authorization type for the route.
     * For WebSocket APIs, valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * For HTTP APIs, valid values are `NONE` for open access, `JWT` for using JSON Web Tokens, `AWS_IAM` for using AWS IAM permissions, and `CUSTOM` for using a Lambda authorizer.
     * Defaults to `NONE`.
     */
    @JvmName("rkiuhueengcycrbi")
    public suspend fun authorizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value Identifier of the `aws.apigatewayv2.Authorizer` resource to be associated with this route.
     */
    @JvmName("nqmmydtpdsgxtlus")
    public suspend fun authorizerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerId = mapped
    }

    /**
     * @param value The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("lkeshvodjedtgqil")
    public suspend fun modelSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelSelectionExpression = mapped
    }

    /**
     * @param value Operation name for the route. Must be between 1 and 64 characters in length.
     */
    @JvmName("tmfjpsetnrbuxgmv")
    public suspend fun operationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationName = mapped
    }

    /**
     * @param value Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("kwauwrpxojwmkuvd")
    public suspend fun requestModels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestModels = mapped
    }

    /**
     * @param values Request models for the route. Supported only for WebSocket APIs.
     */
    @JvmName("hnklnialvvrbpfgh")
    public fun requestModels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestModels = mapped
    }

    /**
     * @param value Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("cyvdgmprghtyjaeg")
    public suspend fun requestParameters(`value`: List<RouteRequestParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("rxxqeqgbekfcuoyu")
    public suspend
    fun requestParameters(argument: List<suspend RouteRequestParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("hlntkdxakmlywvrw")
    public suspend fun requestParameters(
        vararg
        argument: suspend RouteRequestParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteRequestParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param argument Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("hsokvkvkapdncsrm")
    public suspend
    fun requestParameters(argument: suspend RouteRequestParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteRequestParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestParameters = mapped
    }

    /**
     * @param values Request parameters for the route. Supported only for WebSocket APIs.
     */
    @JvmName("rrqykptivbaenjvc")
    public suspend fun requestParameters(vararg values: RouteRequestParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestParameters = mapped
    }

    /**
     * @param value Route key for the route. For HTTP APIs, the route key can be either `$default`, or a combination of an HTTP method and resource path, for example, `GET /pets`.
     */
    @JvmName("ptmthsafmbfvgwse")
    public suspend fun routeKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeKey = mapped
    }

    /**
     * @param value The [route response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-response-selection-expressions) for the route. Supported only for WebSocket APIs.
     */
    @JvmName("xwixlydmxxciskjy")
    public suspend fun routeResponseSelectionExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeResponseSelectionExpression = mapped
    }

    /**
     * @param value Target for the route, of the form `integrations/`*`IntegrationID`*, where *`IntegrationID`* is the identifier of an `aws.apigatewayv2.Integration` resource.
     */
    @JvmName("xrvtqhehirwlcisw")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        apiId = apiId,
        apiKeyRequired = apiKeyRequired,
        authorizationScopes = authorizationScopes,
        authorizationType = authorizationType,
        authorizerId = authorizerId,
        modelSelectionExpression = modelSelectionExpression,
        operationName = operationName,
        requestModels = requestModels,
        requestParameters = requestParameters,
        routeKey = routeKey,
        routeResponseSelectionExpression = routeResponseSelectionExpression,
        target = target,
    )
}
