@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [RouteResponse].
 */
@PulumiTagMarker
public class RouteResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteResponseArgs = RouteResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteResponseArgsBuilder.() -> Unit) {
        val builder = RouteResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteResponse {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.RouteResponse(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteResponse(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 route response.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.RouteResponse;
 * import com.pulumi.aws.apigatewayv2.RouteResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteResponse("example", RouteResponseArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .routeId(aws_apigatewayv2_route.example().id())
 *             .routeResponseKey("$default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_route_response` using the API identifier, route identifier and route response identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/routeResponse:RouteResponse example aabbccddee/1122334/998877
 * ```
 *
 */
public class RouteResponse internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.RouteResponse,
) : KotlinCustomResource(javaResource, RouteResponseMapper) {
    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * The [model selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-model-selection-expressions) for the route response.
     */
    public val modelSelectionExpression: Output<String>?
        get() = javaResource.modelSelectionExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Response models for the route response.
     */
    public val responseModels: Output<Map<String, String>>?
        get() = javaResource.responseModels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Identifier of the `aws.apigatewayv2.Route`.
     */
    public val routeId: Output<String>
        get() = javaResource.routeId().applyValue({ args0 -> args0 })

    /**
     * Route response key.
     */
    public val routeResponseKey: Output<String>
        get() = javaResource.routeResponseKey().applyValue({ args0 -> args0 })
}

public object RouteResponseMapper : ResourceMapper<RouteResponse> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.RouteResponse::class == javaResource::class

    override fun map(javaResource: Resource): RouteResponse = RouteResponse(
        javaResource as
            com.pulumi.aws.apigatewayv2.RouteResponse,
    )
}

/**
 * @see [RouteResponse].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteResponse].
 */
public suspend fun routeResponse(
    name: String,
    block: suspend RouteResponseResourceBuilder.() -> Unit,
): RouteResponse {
    val builder = RouteResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteResponse].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeResponse(name: String): RouteResponse {
    val builder = RouteResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
