@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageAccessLogSettings
import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageDefaultRouteSettings
import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageRouteSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageAccessLogSettings.Companion.toKotlin as stageAccessLogSettingsToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageDefaultRouteSettings.Companion.toKotlin as stageDefaultRouteSettingsToKotlin
import com.pulumi.aws.apigatewayv2.kotlin.outputs.StageRouteSetting.Companion.toKotlin as stageRouteSettingToKotlin

/**
 * Builder for [Stage].
 */
@PulumiTagMarker
public class StageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StageArgs = StageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StageArgsBuilder.() -> Unit) {
        val builder = StageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Stage {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.Stage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stage(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 stage.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Stage;
 * import com.pulumi.aws.apigatewayv2.StageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stage("example", StageArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_stage` using the API identifier and stage name. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/stage:Stage example aabbccddee/example-stage
 * ```
 *  -> __Note:__ The API Gateway managed stage created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 */
public class Stage internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.Stage,
) : KotlinCustomResource(javaResource, StageMapper) {
    /**
     * Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    public val accessLogSettings: Output<StageAccessLogSettings>?
        get() = javaResource.accessLogSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stageAccessLogSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * API identifier.
     */
    public val apiId: Output<String>
        get() = javaResource.apiId().applyValue({ args0 -> args0 })

    /**
     * ARN of the stage.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
     */
    public val autoDeploy: Output<Boolean>?
        get() = javaResource.autoDeploy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
     * Supported only for WebSocket APIs.
     */
    public val clientCertificateId: Output<String>?
        get() = javaResource.clientCertificateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default route settings for the stage.
     */
    public val defaultRouteSettings: Output<StageDefaultRouteSettings>?
        get() = javaResource.defaultRouteSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stageDefaultRouteSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
     */
    public val deploymentId: Output<String>
        get() = javaResource.deploymentId().applyValue({ args0 -> args0 })

    /**
     * Description for the stage. Must be less than or equal to 1024 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN prefix to be used in an `aws.lambda.Permission`'s `source_arn` attribute.
     * For WebSocket APIs this attribute can additionally be used in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
     */
    public val executionArn: Output<String>
        get() = javaResource.executionArn().applyValue({ args0 -> args0 })

    /**
     * URL to invoke the API pointing to the stage,
     * e.g., `wss://z4675bid1j.execute-api.eu-west-2.amazonaws.com/example-stage`, or `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/`
     */
    public val invokeUrl: Output<String>
        get() = javaResource.invokeUrl().applyValue({ args0 -> args0 })

    /**
     * Name of the stage. Must be between 1 and 128 characters in length.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Route settings for the stage.
     */
    public val routeSettings: Output<List<StageRouteSetting>>?
        get() = javaResource.routeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        stageRouteSettingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Map that defines the stage variables for the stage.
     */
    public val stageVariables: Output<Map<String, String>>?
        get() = javaResource.stageVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StageMapper : ResourceMapper<Stage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.Stage::class == javaResource::class

    override fun map(javaResource: Resource): Stage = Stage(
        javaResource as
            com.pulumi.aws.apigatewayv2.Stage,
    )
}

/**
 * @see [Stage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stage].
 */
public suspend fun stage(name: String, block: suspend StageResourceBuilder.() -> Unit): Stage {
    val builder = StageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stage(name: String): Stage {
    val builder = StageResourceBuilder()
    builder.name(name)
    return builder.build()
}
