@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.aws.apigatewayv2.StageArgs.builder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageAccessLogSettingsArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageAccessLogSettingsArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageDefaultRouteSettingsArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageDefaultRouteSettingsArgsBuilder
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageRouteSettingArgs
import com.pulumi.aws.apigatewayv2.kotlin.inputs.StageRouteSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon API Gateway Version 2 stage.
 * More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.Stage;
 * import com.pulumi.aws.apigatewayv2.StageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stage("example", StageArgs.builder()
 *             .apiId(aws_apigatewayv2_api.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_stage` using the API identifier and stage name. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/stage:Stage example aabbccddee/example-stage
 * ```
 *  -> __Note:__ The API Gateway managed stage created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.
 * @property accessLogSettings Settings for logging access in this stage.
 * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
 * @property apiId API identifier.
 * @property autoDeploy Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
 * @property clientCertificateId Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
 * Supported only for WebSocket APIs.
 * @property defaultRouteSettings Default route settings for the stage.
 * @property deploymentId Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
 * @property description Description for the stage. Must be less than or equal to 1024 characters in length.
 * @property name Name of the stage. Must be between 1 and 128 characters in length.
 * The following arguments are optional:
 * @property routeSettings Route settings for the stage.
 * @property stageVariables Map that defines the stage variables for the stage.
 * @property tags Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StageArgs(
    public val accessLogSettings: Output<StageAccessLogSettingsArgs>? = null,
    public val apiId: Output<String>? = null,
    public val autoDeploy: Output<Boolean>? = null,
    public val clientCertificateId: Output<String>? = null,
    public val defaultRouteSettings: Output<StageDefaultRouteSettingsArgs>? = null,
    public val deploymentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routeSettings: Output<List<StageRouteSettingArgs>>? = null,
    public val stageVariables: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.StageArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.StageArgs =
        com.pulumi.aws.apigatewayv2.StageArgs.builder()
            .accessLogSettings(accessLogSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .autoDeploy(autoDeploy?.applyValue({ args0 -> args0 }))
            .clientCertificateId(clientCertificateId?.applyValue({ args0 -> args0 }))
            .defaultRouteSettings(
                defaultRouteSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentId(deploymentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routeSettings(
                routeSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stageVariables(
                stageVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StageArgs].
 */
@PulumiTagMarker
public class StageArgsBuilder internal constructor() {
    private var accessLogSettings: Output<StageAccessLogSettingsArgs>? = null

    private var apiId: Output<String>? = null

    private var autoDeploy: Output<Boolean>? = null

    private var clientCertificateId: Output<String>? = null

    private var defaultRouteSettings: Output<StageDefaultRouteSettingsArgs>? = null

    private var deploymentId: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routeSettings: Output<List<StageRouteSettingArgs>>? = null

    private var stageVariables: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("qhqaitrwdnfgwobe")
    public suspend fun accessLogSettings(`value`: Output<StageAccessLogSettingsArgs>) {
        this.accessLogSettings = value
    }

    /**
     * @param value API identifier.
     */
    @JvmName("cgjijnbqjhndqsbu")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("ttwyunrshpefqner")
    public suspend fun autoDeploy(`value`: Output<Boolean>) {
        this.autoDeploy = value
    }

    /**
     * @param value Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
     * Supported only for WebSocket APIs.
     */
    @JvmName("gynbajewutqwfuky")
    public suspend fun clientCertificateId(`value`: Output<String>) {
        this.clientCertificateId = value
    }

    /**
     * @param value Default route settings for the stage.
     */
    @JvmName("pxesqhhsmcvqmqww")
    public suspend fun defaultRouteSettings(`value`: Output<StageDefaultRouteSettingsArgs>) {
        this.defaultRouteSettings = value
    }

    /**
     * @param value Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
     */
    @JvmName("abuiwtlimefxtpbx")
    public suspend fun deploymentId(`value`: Output<String>) {
        this.deploymentId = value
    }

    /**
     * @param value Description for the stage. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("uvjkhsxiygwktvph")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the stage. Must be between 1 and 128 characters in length.
     * The following arguments are optional:
     */
    @JvmName("ehpfmfcydupgmiyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Route settings for the stage.
     */
    @JvmName("ibolgoimqykwietu")
    public suspend fun routeSettings(`value`: Output<List<StageRouteSettingArgs>>) {
        this.routeSettings = value
    }

    @JvmName("vvtpklqnaeypjmur")
    public suspend fun routeSettings(vararg values: Output<StageRouteSettingArgs>) {
        this.routeSettings = Output.all(values.asList())
    }

    /**
     * @param values Route settings for the stage.
     */
    @JvmName("kegmupohffxhqocd")
    public suspend fun routeSettings(values: List<Output<StageRouteSettingArgs>>) {
        this.routeSettings = Output.all(values)
    }

    /**
     * @param value Map that defines the stage variables for the stage.
     */
    @JvmName("hvwbyetheasbfnwy")
    public suspend fun stageVariables(`value`: Output<Map<String, String>>) {
        this.stageVariables = value
    }

    /**
     * @param value Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("doqtppmijboffwhg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("monynkegmpnmjjqr")
    public suspend fun accessLogSettings(`value`: StageAccessLogSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogSettings = mapped
    }

    /**
     * @param argument Settings for logging access in this stage.
     * Use the `aws.apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
     */
    @JvmName("bljokdrjmrguenuw")
    public suspend
    fun accessLogSettings(argument: suspend StageAccessLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageAccessLogSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogSettings = mapped
    }

    /**
     * @param value API identifier.
     */
    @JvmName("lcigldnqilipqfai")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
     */
    @JvmName("hcyqcfcgojvpdhxg")
    public suspend fun autoDeploy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeploy = mapped
    }

    /**
     * @param value Identifier of a client certificate for the stage. Use the `aws.apigateway.ClientCertificate` resource to configure a client certificate.
     * Supported only for WebSocket APIs.
     */
    @JvmName("rojfylikibkfbfjo")
    public suspend fun clientCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateId = mapped
    }

    /**
     * @param value Default route settings for the stage.
     */
    @JvmName("diteadtehofjgodo")
    public suspend fun defaultRouteSettings(`value`: StageDefaultRouteSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteSettings = mapped
    }

    /**
     * @param argument Default route settings for the stage.
     */
    @JvmName("itkwlryjwqwstufx")
    public suspend
    fun defaultRouteSettings(argument: suspend StageDefaultRouteSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StageDefaultRouteSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultRouteSettings = mapped
    }

    /**
     * @param value Deployment identifier of the stage. Use the `aws.apigatewayv2.Deployment` resource to configure a deployment.
     */
    @JvmName("yxbxvubgsqxvywxi")
    public suspend fun deploymentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentId = mapped
    }

    /**
     * @param value Description for the stage. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("yivliflodhaqpcoo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the stage. Must be between 1 and 128 characters in length.
     * The following arguments are optional:
     */
    @JvmName("kidhvbaqaueggdok")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Route settings for the stage.
     */
    @JvmName("mgsooxfomoochwfe")
    public suspend fun routeSettings(`value`: List<StageRouteSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("wsbidfsaervuiiuo")
    public suspend
    fun routeSettings(argument: List<suspend StageRouteSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StageRouteSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("kxfcaapcktxtslqc")
    public suspend fun routeSettings(
        vararg
        argument: suspend StageRouteSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StageRouteSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param argument Route settings for the stage.
     */
    @JvmName("vpowbibvclabmbak")
    public suspend fun routeSettings(argument: suspend StageRouteSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StageRouteSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routeSettings = mapped
    }

    /**
     * @param values Route settings for the stage.
     */
    @JvmName("qsyadfmdmuhakelw")
    public suspend fun routeSettings(vararg values: StageRouteSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeSettings = mapped
    }

    /**
     * @param value Map that defines the stage variables for the stage.
     */
    @JvmName("vbaeuvyqwtmcgybb")
    public suspend fun stageVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageVariables = mapped
    }

    /**
     * @param values Map that defines the stage variables for the stage.
     */
    @JvmName("npejyogswncmiulb")
    public fun stageVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageVariables = mapped
    }

    /**
     * @param value Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqopexmalquolqkn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rhkclhlcndcwtbuf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StageArgs = StageArgs(
        accessLogSettings = accessLogSettings,
        apiId = apiId,
        autoDeploy = autoDeploy,
        clientCertificateId = clientCertificateId,
        defaultRouteSettings = defaultRouteSettings,
        deploymentId = deploymentId,
        description = description,
        name = name,
        routeSettings = routeSettings,
        stageVariables = stageVariables,
        tags = tags,
    )
}
