@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcLink].
 */
@PulumiTagMarker
public class VpcLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcLinkArgs = VpcLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcLinkArgsBuilder.() -> Unit) {
        val builder = VpcLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcLink {
        val builtJavaResource = com.pulumi.aws.apigatewayv2.VpcLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcLink(builtJavaResource)
    }
}

/**
 * Manages an Amazon API Gateway Version 2 VPC Link.
 * > **Note:** Amazon API Gateway Version 2 VPC Links enable private integrations that connect HTTP APIs to private resources in a VPC.
 * To enable private integration for REST APIs, use the Amazon API Gateway Version 1 VPC Link resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigatewayv2.VpcLink;
 * import com.pulumi.aws.apigatewayv2.VpcLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcLink("example", VpcLinkArgs.builder()
 *             .securityGroupIds(data.aws_security_group().example().id())
 *             .subnetIds(data.aws_subnets().example().ids())
 *             .tags(Map.of("Usage", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_apigatewayv2_vpc_link` using the VPC Link identifier. For example:
 * ```sh
 *  $ pulumi import aws:apigatewayv2/vpcLink:VpcLink example aabbccddee
 * ```
 *
 */
public class VpcLink internal constructor(
    override val javaResource: com.pulumi.aws.apigatewayv2.VpcLink,
) : KotlinCustomResource(javaResource, VpcLinkMapper) {
    /**
     * VPC Link ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the VPC Link. Must be between 1 and 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Security group IDs for the VPC Link.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subnet IDs for the VPC Link.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the VPC Link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcLinkMapper : ResourceMapper<VpcLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigatewayv2.VpcLink::class == javaResource::class

    override fun map(javaResource: Resource): VpcLink = VpcLink(
        javaResource as
            com.pulumi.aws.apigatewayv2.VpcLink,
    )
}

/**
 * @see [VpcLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcLink].
 */
public suspend fun vpcLink(name: String, block: suspend VpcLinkResourceBuilder.() -> Unit):
    VpcLink {
    val builder = VpcLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcLink(name: String): VpcLink {
    val builder = VpcLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
