@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowCredentials Whether credentials are included in the CORS request.
 * @property allowHeaders Set of allowed HTTP headers.
 * @property allowMethods Set of allowed HTTP methods.
 * @property allowOrigins Set of allowed origins.
 * @property exposeHeaders Set of exposed HTTP headers.
 * @property maxAge Number of seconds that the browser should cache preflight request results.
 */
public data class ApiCorsConfigurationArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val allowHeaders: Output<List<String>>? = null,
    public val allowMethods: Output<List<String>>? = null,
    public val allowOrigins: Output<List<String>>? = null,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs =
        com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowHeaders(allowHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowMethods(allowMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowOrigins(allowOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiCorsConfigurationArgs].
 */
@PulumiTagMarker
public class ApiCorsConfigurationArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var allowHeaders: Output<List<String>>? = null

    private var allowMethods: Output<List<String>>? = null

    private var allowOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value Whether credentials are included in the CORS request.
     */
    @JvmName("ngmkjlpjnsrgyeay")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value Set of allowed HTTP headers.
     */
    @JvmName("saxdsqvsdfxowcvr")
    public suspend fun allowHeaders(`value`: Output<List<String>>) {
        this.allowHeaders = value
    }

    @JvmName("nwabkurqmrfdiepy")
    public suspend fun allowHeaders(vararg values: Output<String>) {
        this.allowHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed HTTP headers.
     */
    @JvmName("syajbtywcjakknoj")
    public suspend fun allowHeaders(values: List<Output<String>>) {
        this.allowHeaders = Output.all(values)
    }

    /**
     * @param value Set of allowed HTTP methods.
     */
    @JvmName("scwuixfonwwvesri")
    public suspend fun allowMethods(`value`: Output<List<String>>) {
        this.allowMethods = value
    }

    @JvmName("xdjtsuvpldyionxi")
    public suspend fun allowMethods(vararg values: Output<String>) {
        this.allowMethods = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed HTTP methods.
     */
    @JvmName("dfvihybbjwlsuqta")
    public suspend fun allowMethods(values: List<Output<String>>) {
        this.allowMethods = Output.all(values)
    }

    /**
     * @param value Set of allowed origins.
     */
    @JvmName("qiiojavooptcdoku")
    public suspend fun allowOrigins(`value`: Output<List<String>>) {
        this.allowOrigins = value
    }

    @JvmName("poftbunusocmbqey")
    public suspend fun allowOrigins(vararg values: Output<String>) {
        this.allowOrigins = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed origins.
     */
    @JvmName("wovjdlepmitqtqls")
    public suspend fun allowOrigins(values: List<Output<String>>) {
        this.allowOrigins = Output.all(values)
    }

    /**
     * @param value Set of exposed HTTP headers.
     */
    @JvmName("jajadwbtxdhgnpmn")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("scjppfapirwlcloa")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of exposed HTTP headers.
     */
    @JvmName("kkqwkojsmhvwtnkm")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value Number of seconds that the browser should cache preflight request results.
     */
    @JvmName("veamyvwyuiavpuxg")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value Whether credentials are included in the CORS request.
     */
    @JvmName("fwnpokxtlncgmyjk")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value Set of allowed HTTP headers.
     */
    @JvmName("dfflqajvnhyfdwcq")
    public suspend fun allowHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param values Set of allowed HTTP headers.
     */
    @JvmName("hiptoorjqlwqqjte")
    public suspend fun allowHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param value Set of allowed HTTP methods.
     */
    @JvmName("otdpvvoyyakqyqiw")
    public suspend fun allowMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param values Set of allowed HTTP methods.
     */
    @JvmName("vrycjdwjucyxmgfl")
    public suspend fun allowMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param value Set of allowed origins.
     */
    @JvmName("wcbjjqpupgdgvrsk")
    public suspend fun allowOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param values Set of allowed origins.
     */
    @JvmName("gbfvebbgynodgyjg")
    public suspend fun allowOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param value Set of exposed HTTP headers.
     */
    @JvmName("idwoeuouuxunebyk")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values Set of exposed HTTP headers.
     */
    @JvmName("wljtmicujoakfupx")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value Number of seconds that the browser should cache preflight request results.
     */
    @JvmName("dlupugypjgusxici")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): ApiCorsConfigurationArgs = ApiCorsConfigurationArgs(
        allowCredentials = allowCredentials,
        allowHeaders = allowHeaders,
        allowMethods = allowMethods,
        allowOrigins = allowOrigins,
        exposeHeaders = exposeHeaders,
        maxAge = maxAge,
    )
}
