@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.AuthorizerJwtConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audiences List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
 * @property issuer Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `aws.cognito.UserPool` resource.
 */
public data class AuthorizerJwtConfigurationArgs(
    public val audiences: Output<List<String>>? = null,
    public val issuer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.AuthorizerJwtConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.AuthorizerJwtConfigurationArgs =
        com.pulumi.aws.apigatewayv2.inputs.AuthorizerJwtConfigurationArgs.builder()
            .audiences(audiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .issuer(issuer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizerJwtConfigurationArgs].
 */
@PulumiTagMarker
public class AuthorizerJwtConfigurationArgsBuilder internal constructor() {
    private var audiences: Output<List<String>>? = null

    private var issuer: Output<String>? = null

    /**
     * @param value List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
     */
    @JvmName("pcsnafektgpvvbcf")
    public suspend fun audiences(`value`: Output<List<String>>) {
        this.audiences = value
    }

    @JvmName("bfjvijxspqurwhxj")
    public suspend fun audiences(vararg values: Output<String>) {
        this.audiences = Output.all(values.asList())
    }

    /**
     * @param values List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
     */
    @JvmName("umxxuottquwscfeo")
    public suspend fun audiences(values: List<Output<String>>) {
        this.audiences = Output.all(values)
    }

    /**
     * @param value Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `aws.cognito.UserPool` resource.
     */
    @JvmName("mnrvkwsqlmkdixxg")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
     */
    @JvmName("vbvxqaawpqjrnnbn")
    public suspend fun audiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param values List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
     */
    @JvmName("etwloqboxyinnkcj")
    public suspend fun audiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audiences = mapped
    }

    /**
     * @param value Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `aws.cognito.UserPool` resource.
     */
    @JvmName("pesmoskyxeccaygg")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    internal fun build(): AuthorizerJwtConfigurationArgs = AuthorizerJwtConfigurationArgs(
        audiences = audiences,
        issuer = issuer,
    )
}
