@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.DomainNameMutualTlsAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property truststoreUri Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
 * @property truststoreVersion Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
 */
public data class DomainNameMutualTlsAuthenticationArgs(
    public val truststoreUri: Output<String>,
    public val truststoreVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.DomainNameMutualTlsAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.DomainNameMutualTlsAuthenticationArgs =
        com.pulumi.aws.apigatewayv2.inputs.DomainNameMutualTlsAuthenticationArgs.builder()
            .truststoreUri(truststoreUri.applyValue({ args0 -> args0 }))
            .truststoreVersion(truststoreVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameMutualTlsAuthenticationArgs].
 */
@PulumiTagMarker
public class DomainNameMutualTlsAuthenticationArgsBuilder internal constructor() {
    private var truststoreUri: Output<String>? = null

    private var truststoreVersion: Output<String>? = null

    /**
     * @param value Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
     */
    @JvmName("byafnsmymsxcmgux")
    public suspend fun truststoreUri(`value`: Output<String>) {
        this.truststoreUri = value
    }

    /**
     * @param value Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
     */
    @JvmName("jtddewotascpjher")
    public suspend fun truststoreVersion(`value`: Output<String>) {
        this.truststoreVersion = value
    }

    /**
     * @param value Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
     */
    @JvmName("igstmipkbebpdeag")
    public suspend fun truststoreUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.truststoreUri = mapped
    }

    /**
     * @param value Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
     */
    @JvmName("hmumwhunfgwmlroo")
    public suspend fun truststoreVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.truststoreVersion = mapped
    }

    internal fun build(): DomainNameMutualTlsAuthenticationArgs =
        DomainNameMutualTlsAuthenticationArgs(
            truststoreUri = truststoreUri ?: throw PulumiNullFieldException("truststoreUri"),
            truststoreVersion = truststoreVersion,
        )
}
