@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.GetApisPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApis.
 * @property name API name.
 * @property protocolType API protocol.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired APIs.
 */
public data class GetApisPlainArgs(
    public val name: String? = null,
    public val protocolType: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.GetApisPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.GetApisPlainArgs =
        com.pulumi.aws.apigatewayv2.inputs.GetApisPlainArgs.builder()
            .name(name?.let({ args0 -> args0 }))
            .protocolType(protocolType?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetApisPlainArgs].
 */
@PulumiTagMarker
public class GetApisPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var protocolType: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value API name.
     */
    @JvmName("avwwhecquqxdlqxa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value API protocol.
     */
    @JvmName("xrkqjtvaqhmjnyho")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocolType = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired APIs.
     */
    @JvmName("rpwttblpfrcirrms")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired APIs.
     */
    @JvmName("rtxtukxfdokyjwsw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetApisPlainArgs = GetApisPlainArgs(
        name = name,
        protocolType = protocolType,
        tags = tags,
    )
}
