@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property mappings Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
 * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
 * @property statusCode HTTP status code in the range 200-599.
 */
public data class IntegrationResponseParameterArgs(
    public val mappings: Output<Map<String, String>>,
    public val statusCode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs =
        com.pulumi.aws.apigatewayv2.inputs.IntegrationResponseParameterArgs.builder()
            .mappings(mappings.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .statusCode(statusCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationResponseParameterArgs].
 */
@PulumiTagMarker
public class IntegrationResponseParameterArgsBuilder internal constructor() {
    private var mappings: Output<Map<String, String>>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("bghvmufliqxvxngu")
    public suspend fun mappings(`value`: Output<Map<String, String>>) {
        this.mappings = value
    }

    /**
     * @param value HTTP status code in the range 200-599.
     */
    @JvmName("ycqjqmwrmydujqlt")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("ohumwilnedwthuxm")
    public suspend fun mappings(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param values Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
     * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
     */
    @JvmName("rqbbsflitjyhtukg")
    public fun mappings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param value HTTP status code in the range 200-599.
     */
    @JvmName("vskdlcqlsdepqxoq")
    public suspend fun statusCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): IntegrationResponseParameterArgs = IntegrationResponseParameterArgs(
        mappings = mappings ?: throw PulumiNullFieldException("mappings"),
        statusCode = statusCode ?: throw PulumiNullFieldException("statusCode"),
    )
}
