@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.RouteRequestParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property requestParameterKey Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
 * @property required Boolean whether or not the parameter is required.
 */
public data class RouteRequestParameterArgs(
    public val requestParameterKey: Output<String>,
    public val required: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.RouteRequestParameterArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.RouteRequestParameterArgs =
        com.pulumi.aws.apigatewayv2.inputs.RouteRequestParameterArgs.builder()
            .requestParameterKey(requestParameterKey.applyValue({ args0 -> args0 }))
            .required(required.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteRequestParameterArgs].
 */
@PulumiTagMarker
public class RouteRequestParameterArgsBuilder internal constructor() {
    private var requestParameterKey: Output<String>? = null

    private var required: Output<Boolean>? = null

    /**
     * @param value Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
     */
    @JvmName("irxdxeqgxjutmobq")
    public suspend fun requestParameterKey(`value`: Output<String>) {
        this.requestParameterKey = value
    }

    /**
     * @param value Boolean whether or not the parameter is required.
     */
    @JvmName("osipridtypcatgbf")
    public suspend fun required(`value`: Output<Boolean>) {
        this.required = value
    }

    /**
     * @param value Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
     */
    @JvmName("dstnuivoxvbkgcrk")
    public suspend fun requestParameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestParameterKey = mapped
    }

    /**
     * @param value Boolean whether or not the parameter is required.
     */
    @JvmName("xykosoolemhfrycq")
    public suspend fun required(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.required = mapped
    }

    internal fun build(): RouteRequestParameterArgs = RouteRequestParameterArgs(
        requestParameterKey = requestParameterKey ?: throw PulumiNullFieldException("requestParameterKey"),
        required = required ?: throw PulumiNullFieldException("required"),
    )
}
