@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.StageAccessLogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationArn ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
 * @property format Single line [format](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/set-up-logging&#46;html#apigateway-cloudwatch-log-formats) of the access logs of data&#46; Refer to log settings for [HTTP](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-logging-variables&#46;html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
 */
public data class StageAccessLogSettingsArgs(
    public val destinationArn: Output<String>,
    public val format: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.StageAccessLogSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.StageAccessLogSettingsArgs =
        com.pulumi.aws.apigatewayv2.inputs.StageAccessLogSettingsArgs.builder()
            .destinationArn(destinationArn.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageAccessLogSettingsArgs].
 */
@PulumiTagMarker
public class StageAccessLogSettingsArgsBuilder internal constructor() {
    private var destinationArn: Output<String>? = null

    private var format: Output<String>? = null

    /**
     * @param value ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
     */
    @JvmName("dbumlvvpwbbvewvs")
    public suspend fun destinationArn(`value`: Output<String>) {
        this.destinationArn = value
    }

    /**
     * @param value Single line [format](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/set-up-logging&#46;html#apigateway-cloudwatch-log-formats) of the access logs of data&#46; Refer to log settings for [HTTP](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-logging-variables&#46;html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
     */
    @JvmName("fmmgfgublqwrkarf")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
     */
    @JvmName("vpminpqnmhxkukgp")
    public suspend fun destinationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationArn = mapped
    }

    /**
     * @param value Single line [format](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/set-up-logging&#46;html#apigateway-cloudwatch-log-formats) of the access logs of data&#46; Refer to log settings for [HTTP](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-logging-variables&#46;html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
     */
    @JvmName("cvatjwogpsnubdew")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    internal fun build(): StageAccessLogSettingsArgs = StageAccessLogSettingsArgs(
        destinationArn = destinationArn ?: throw PulumiNullFieldException("destinationArn"),
        format = format ?: throw PulumiNullFieldException("format"),
    )
}
