@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.StageDefaultRouteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataTraceEnabled Whether data trace logging is enabled for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Defaults to `false`. Supported only for WebSocket APIs.
 * @property detailedMetricsEnabled Whether detailed metrics are enabled for the default route. Defaults to `false`.
 * @property loggingLevel Logging level for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
 * @property throttlingBurstLimit Throttling burst limit for the default route.
 * @property throttlingRateLimit Throttling rate limit for the default route.
 */
public data class StageDefaultRouteSettingsArgs(
    public val dataTraceEnabled: Output<Boolean>? = null,
    public val detailedMetricsEnabled: Output<Boolean>? = null,
    public val loggingLevel: Output<String>? = null,
    public val throttlingBurstLimit: Output<Int>? = null,
    public val throttlingRateLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.StageDefaultRouteSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.StageDefaultRouteSettingsArgs =
        com.pulumi.aws.apigatewayv2.inputs.StageDefaultRouteSettingsArgs.builder()
            .dataTraceEnabled(dataTraceEnabled?.applyValue({ args0 -> args0 }))
            .detailedMetricsEnabled(detailedMetricsEnabled?.applyValue({ args0 -> args0 }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .throttlingBurstLimit(throttlingBurstLimit?.applyValue({ args0 -> args0 }))
            .throttlingRateLimit(throttlingRateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageDefaultRouteSettingsArgs].
 */
@PulumiTagMarker
public class StageDefaultRouteSettingsArgsBuilder internal constructor() {
    private var dataTraceEnabled: Output<Boolean>? = null

    private var detailedMetricsEnabled: Output<Boolean>? = null

    private var loggingLevel: Output<String>? = null

    private var throttlingBurstLimit: Output<Int>? = null

    private var throttlingRateLimit: Output<Double>? = null

    /**
     * @param value Whether data trace logging is enabled for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("voahsuglfexotqwy")
    public suspend fun dataTraceEnabled(`value`: Output<Boolean>) {
        this.dataTraceEnabled = value
    }

    /**
     * @param value Whether detailed metrics are enabled for the default route. Defaults to `false`.
     */
    @JvmName("vraiqmhkgvbllysb")
    public suspend fun detailedMetricsEnabled(`value`: Output<Boolean>) {
        this.detailedMetricsEnabled = value
    }

    /**
     * @param value Logging level for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("lklfqktjsidcwtwe")
    public suspend fun loggingLevel(`value`: Output<String>) {
        this.loggingLevel = value
    }

    /**
     * @param value Throttling burst limit for the default route.
     */
    @JvmName("vlqwgjyyurndpubr")
    public suspend fun throttlingBurstLimit(`value`: Output<Int>) {
        this.throttlingBurstLimit = value
    }

    /**
     * @param value Throttling rate limit for the default route.
     */
    @JvmName("pxkvigxgjgvqgfxg")
    public suspend fun throttlingRateLimit(`value`: Output<Double>) {
        this.throttlingRateLimit = value
    }

    /**
     * @param value Whether data trace logging is enabled for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("cutuaryqpufcouxo")
    public suspend fun dataTraceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTraceEnabled = mapped
    }

    /**
     * @param value Whether detailed metrics are enabled for the default route. Defaults to `false`.
     */
    @JvmName("hlesyblngapmvblq")
    public suspend fun detailedMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedMetricsEnabled = mapped
    }

    /**
     * @param value Logging level for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("djqfmtfemqohaitb")
    public suspend fun loggingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Throttling burst limit for the default route.
     */
    @JvmName("aqmpydfoqwhvnvoo")
    public suspend fun throttlingBurstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingBurstLimit = mapped
    }

    /**
     * @param value Throttling rate limit for the default route.
     */
    @JvmName("elmklbuvogviimha")
    public suspend fun throttlingRateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingRateLimit = mapped
    }

    internal fun build(): StageDefaultRouteSettingsArgs = StageDefaultRouteSettingsArgs(
        dataTraceEnabled = dataTraceEnabled,
        detailedMetricsEnabled = detailedMetricsEnabled,
        loggingLevel = loggingLevel,
        throttlingBurstLimit = throttlingBurstLimit,
        throttlingRateLimit = throttlingRateLimit,
    )
}
