@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateArn ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `aws.acm.Certificate` resource to configure an ACM certificate.
 * @property endpointType Endpoint type. Valid values: `REGIONAL`.
 * @property hostedZoneId Amazon Route 53 Hosted Zone ID of the endpoint.
 * @property ownershipVerificationCertificateArn ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
 * @property securityPolicy Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
 * @property targetDomainName Target domain name.
 */
public data class DomainNameDomainNameConfiguration(
    public val certificateArn: String,
    public val endpointType: String,
    public val hostedZoneId: String? = null,
    public val ownershipVerificationCertificateArn: String? = null,
    public val securityPolicy: String,
    public val targetDomainName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.DomainNameDomainNameConfiguration):
            DomainNameDomainNameConfiguration = DomainNameDomainNameConfiguration(
            certificateArn = javaType.certificateArn(),
            endpointType = javaType.endpointType(),
            hostedZoneId = javaType.hostedZoneId().map({ args0 -> args0 }).orElse(null),
            ownershipVerificationCertificateArn = javaType.ownershipVerificationCertificateArn().map({ args0 ->
                args0
            }).orElse(null),
            securityPolicy = javaType.securityPolicy(),
            targetDomainName = javaType.targetDomainName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
