@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowCredentials Whether credentials are included in the CORS request.
 * @property allowHeaders Set of allowed HTTP headers.
 * @property allowMethods Set of allowed HTTP methods.
 * @property allowOrigins Set of allowed origins.
 * @property exposeHeaders Set of exposed HTTP headers.
 * @property maxAge Number of seconds that the browser should cache preflight request results.
 */
public data class GetApiCorsConfiguration(
    public val allowCredentials: Boolean,
    public val allowHeaders: List<String>,
    public val allowMethods: List<String>,
    public val allowOrigins: List<String>,
    public val exposeHeaders: List<String>,
    public val maxAge: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.GetApiCorsConfiguration):
            GetApiCorsConfiguration = GetApiCorsConfiguration(
            allowCredentials = javaType.allowCredentials(),
            allowHeaders = javaType.allowHeaders().map({ args0 -> args0 }),
            allowMethods = javaType.allowMethods().map({ args0 -> args0 }),
            allowOrigins = javaType.allowOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            maxAge = javaType.maxAge(),
        )
    }
}
