@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getExport.
 * @property apiId
 * @property body ID of the API.
 * @property exportVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeExtensions
 * @property outputType
 * @property specification
 * @property stageName
 */
public data class GetExportResult(
    public val apiId: String,
    public val body: String,
    public val exportVersion: String? = null,
    public val id: String,
    public val includeExtensions: Boolean? = null,
    public val outputType: String,
    public val specification: String,
    public val stageName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.GetExportResult):
            GetExportResult = GetExportResult(
            apiId = javaType.apiId(),
            body = javaType.body(),
            exportVersion = javaType.exportVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            includeExtensions = javaType.includeExtensions().map({ args0 -> args0 }).orElse(null),
            outputType = javaType.outputType(),
            specification = javaType.specification(),
            stageName = javaType.stageName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
